# generated by datamodel-codegen:
#   filename:  prompt_inspection.yaml

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional
from uuid import UUID

from pydantic import BaseModel, Field


class ActorType(Enum):
    bot = 'bot'
    ip = 'ip'
    user = 'user'


class Actor(BaseModel):
    actor: Optional[str] = Field(None, example='0.0.0.0')
    actorType: Optional[ActorType] = Field(None, example='ip')
    role: Optional[str] = Field(None, example='service')


class Context(BaseModel):
    prompt: str = Field(..., example='... order by total_amount')
    seqId: Optional[UUID] = None
    apiName: str = Field(..., example='chartbot')
    apiEndpoint: str = Field(..., example='GET/prompt')
    additionalInfo: Optional[Dict[str, Any]] = None


class CheckPromptAnswer(Actor, Context):
    response: str
    reqId: UUID


class Result(Enum):
    safe = 'safe'
    suspected_prompt_injection = 'suspected prompt injection'


class CheckPromptResponse(BaseModel):
    result: Result
    description: str
    seqId: UUID
    reqId: UUID


class UnknownErrorResponse(BaseModel):
    reason: str
    status: str


class CheckPrompt(Actor, Context):
    pass
