"""BevelGearAbstractMaterialDatabase"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy.materials import _270
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_BEVEL_GEAR_ABSTRACT_MATERIAL_DATABASE = python_net_import(
    "SMT.MastaAPI.Gears.Materials", "BevelGearAbstractMaterialDatabase"
)

if TYPE_CHECKING:
    from mastapy.gears.materials import _587, _586
    from mastapy.utility.databases import _1830, _1833, _1826


__docformat__ = "restructuredtext en"
__all__ = ("BevelGearAbstractMaterialDatabase",)


Self = TypeVar("Self", bound="BevelGearAbstractMaterialDatabase")
T = TypeVar("T", bound="_587.BevelGearMaterial")


class BevelGearAbstractMaterialDatabase(_270.MaterialDatabase[T]):
    """BevelGearAbstractMaterialDatabase

    This is a mastapy class.

    Generic Types:
        T
    """

    TYPE = _BEVEL_GEAR_ABSTRACT_MATERIAL_DATABASE
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_BevelGearAbstractMaterialDatabase")

    class _Cast_BevelGearAbstractMaterialDatabase:
        """Special nested class for casting BevelGearAbstractMaterialDatabase to subclasses."""

        def __init__(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
            parent: "BevelGearAbstractMaterialDatabase",
        ):
            self._parent = parent

        @property
        def material_database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "_270.MaterialDatabase":
            return self._parent._cast(_270.MaterialDatabase)

        @property
        def named_database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "_1830.NamedDatabase":
            from mastapy.utility.databases import _1830

            return self._parent._cast(_1830.NamedDatabase)

        @property
        def sql_database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "_1833.SQLDatabase":
            pass

            from mastapy.utility.databases import _1833

            return self._parent._cast(_1833.SQLDatabase)

        @property
        def database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "_1826.Database":
            pass

            from mastapy.utility.databases import _1826

            return self._parent._cast(_1826.Database)

        @property
        def bevel_gear_iso_material_database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "_586.BevelGearISOMaterialDatabase":
            from mastapy.gears.materials import _586

            return self._parent._cast(_586.BevelGearISOMaterialDatabase)

        @property
        def bevel_gear_abstract_material_database(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
        ) -> "BevelGearAbstractMaterialDatabase":
            return self._parent

        def __getattr__(
            self: "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "BevelGearAbstractMaterialDatabase.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def cast_to(
        self: Self,
    ) -> "BevelGearAbstractMaterialDatabase._Cast_BevelGearAbstractMaterialDatabase":
        return self._Cast_BevelGearAbstractMaterialDatabase(self)
