"""ConceptGearRating"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal import constructor
from mastapy.gears.rating import _361
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_CONCEPT_GEAR_RATING = python_net_import(
    "SMT.MastaAPI.Gears.Rating.Concept", "ConceptGearRating"
)

if TYPE_CHECKING:
    from mastapy.gears.rating import _359, _354
    from mastapy.gears.gear_designs.concept import _1177
    from mastapy.gears.analysis import _1216


__docformat__ = "restructuredtext en"
__all__ = ("ConceptGearRating",)


Self = TypeVar("Self", bound="ConceptGearRating")


class ConceptGearRating(_361.GearRating):
    """ConceptGearRating

    This is a mastapy class.
    """

    TYPE = _CONCEPT_GEAR_RATING
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_ConceptGearRating")

    class _Cast_ConceptGearRating:
        """Special nested class for casting ConceptGearRating to subclasses."""

        def __init__(
            self: "ConceptGearRating._Cast_ConceptGearRating",
            parent: "ConceptGearRating",
        ):
            self._parent = parent

        @property
        def gear_rating(
            self: "ConceptGearRating._Cast_ConceptGearRating",
        ) -> "_361.GearRating":
            return self._parent._cast(_361.GearRating)

        @property
        def abstract_gear_rating(
            self: "ConceptGearRating._Cast_ConceptGearRating",
        ) -> "_354.AbstractGearRating":
            from mastapy.gears.rating import _354

            return self._parent._cast(_354.AbstractGearRating)

        @property
        def abstract_gear_analysis(
            self: "ConceptGearRating._Cast_ConceptGearRating",
        ) -> "_1216.AbstractGearAnalysis":
            from mastapy.gears.analysis import _1216

            return self._parent._cast(_1216.AbstractGearAnalysis)

        @property
        def concept_gear_rating(
            self: "ConceptGearRating._Cast_ConceptGearRating",
        ) -> "ConceptGearRating":
            return self._parent

        def __getattr__(self: "ConceptGearRating._Cast_ConceptGearRating", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "ConceptGearRating.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def concave_flank_rating(self: Self) -> "_359.GearFlankRating":
        """mastapy.gears.rating.GearFlankRating

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ConcaveFlankRating

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def concept_gear(self: Self) -> "_1177.ConceptGearDesign":
        """mastapy.gears.gear_designs.concept.ConceptGearDesign

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ConceptGear

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def convex_flank_rating(self: Self) -> "_359.GearFlankRating":
        """mastapy.gears.rating.GearFlankRating

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ConvexFlankRating

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: Self) -> "ConceptGearRating._Cast_ConceptGearRating":
        return self._Cast_ConceptGearRating(self)
