"""BHCurveSpecification"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_BH_CURVE_SPECIFICATION = python_net_import(
    "SMT.MastaAPI.Materials", "BHCurveSpecification"
)

if TYPE_CHECKING:
    from mastapy.math_utility import _1537
    from mastapy.utility_gui.charts import _1869
    from mastapy.materials import _247


__docformat__ = "restructuredtext en"
__all__ = ("BHCurveSpecification",)


Self = TypeVar("Self", bound="BHCurveSpecification")


class BHCurveSpecification(_0.APIBase):
    """BHCurveSpecification

    This is a mastapy class.
    """

    TYPE = _BH_CURVE_SPECIFICATION
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_BHCurveSpecification")

    class _Cast_BHCurveSpecification:
        """Special nested class for casting BHCurveSpecification to subclasses."""

        def __init__(
            self: "BHCurveSpecification._Cast_BHCurveSpecification",
            parent: "BHCurveSpecification",
        ):
            self._parent = parent

        @property
        def bh_curve_specification(
            self: "BHCurveSpecification._Cast_BHCurveSpecification",
        ) -> "BHCurveSpecification":
            return self._parent

        def __getattr__(
            self: "BHCurveSpecification._Cast_BHCurveSpecification", name: str
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "BHCurveSpecification.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def bh_curve(self: Self) -> "_1537.Vector2DListAccessor":
        """mastapy.math_utility.Vector2DListAccessor"""
        temp = self.wrapped.BHCurve

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @bh_curve.setter
    @enforce_parameter_types
    def bh_curve(self: Self, value: "_1537.Vector2DListAccessor"):
        self.wrapped.BHCurve = value.wrapped

    @property
    def bh_curve_plot(self: Self) -> "_1869.TwoDChartDefinition":
        """mastapy.utility_gui.charts.TwoDChartDefinition

        Note:
            This property is readonly.
        """
        temp = self.wrapped.BHCurvePlot

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def bh_curve_extrapolation_method(self: Self) -> "_247.BHCurveExtrapolationMethod":
        """mastapy.materials.BHCurveExtrapolationMethod"""
        temp = self.wrapped.BHCurveExtrapolationMethod

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp, "SMT.MastaAPI.Materials.BHCurveExtrapolationMethod"
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy.materials._247", "BHCurveExtrapolationMethod"
        )(value)

    @bh_curve_extrapolation_method.setter
    @enforce_parameter_types
    def bh_curve_extrapolation_method(
        self: Self, value: "_247.BHCurveExtrapolationMethod"
    ):
        value = conversion.mp_to_pn_enum(
            value, "SMT.MastaAPI.Materials.BHCurveExtrapolationMethod"
        )
        self.wrapped.BHCurveExtrapolationMethod = value

    @property
    def maximum_h_for_bh_curve_extrapolation(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumHForBHCurveExtrapolation

        if temp is None:
            return 0.0

        return temp

    @maximum_h_for_bh_curve_extrapolation.setter
    @enforce_parameter_types
    def maximum_h_for_bh_curve_extrapolation(self: Self, value: "float"):
        self.wrapped.MaximumHForBHCurveExtrapolation = (
            float(value) if value is not None else 0.0
        )

    @property
    def name(self: Self) -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Name

        if temp is None:
            return ""

        return temp

    @property
    def number_of_points_for_bh_curve_extrapolation(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfPointsForBHCurveExtrapolation

        if temp is None:
            return 0

        return temp

    @number_of_points_for_bh_curve_extrapolation.setter
    @enforce_parameter_types
    def number_of_points_for_bh_curve_extrapolation(self: Self, value: "int"):
        self.wrapped.NumberOfPointsForBHCurveExtrapolation = (
            int(value) if value is not None else 0
        )

    @property
    def report_names(self: Self) -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ReportNames

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else "")

    def get_default_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else "")

    @enforce_parameter_types
    def output_active_report_as_text_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else "")

    def get_active_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_named_report_to(self: Self, report_name: "str", file_path: "str"):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: Self, report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(
            report_name if report_name else ""
        )
        return method_result

    @property
    def cast_to(self: Self) -> "BHCurveSpecification._Cast_BHCurveSpecification":
        return self._Cast_BHCurveSpecification(self)
