"""SpeedOptionsForHarmonicAnalysisResults"""

from __future__ import annotations

from typing import TypeVar, Union, Tuple, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal.implicit import overridable
from mastapy._internal.overridable_constructor import _unpack_overridable
from mastapy._internal import constructor, conversion
from mastapy.system_model.analyses_and_results.analysis_cases import _7538
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_SPEED_OPTIONS_FOR_HARMONIC_ANALYSIS_RESULTS = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.HarmonicAnalyses",
    "SpeedOptionsForHarmonicAnalysisResults",
)


__docformat__ = "restructuredtext en"
__all__ = ("SpeedOptionsForHarmonicAnalysisResults",)


Self = TypeVar("Self", bound="SpeedOptionsForHarmonicAnalysisResults")


class SpeedOptionsForHarmonicAnalysisResults(
    _7538.AbstractAnalysisOptions["_6807.StaticLoadCase"]
):
    """SpeedOptionsForHarmonicAnalysisResults

    This is a mastapy class.
    """

    TYPE = _SPEED_OPTIONS_FOR_HARMONIC_ANALYSIS_RESULTS
    _CastSelf = TypeVar(
        "_CastSelf", bound="_Cast_SpeedOptionsForHarmonicAnalysisResults"
    )

    class _Cast_SpeedOptionsForHarmonicAnalysisResults:
        """Special nested class for casting SpeedOptionsForHarmonicAnalysisResults to subclasses."""

        def __init__(
            self: "SpeedOptionsForHarmonicAnalysisResults._Cast_SpeedOptionsForHarmonicAnalysisResults",
            parent: "SpeedOptionsForHarmonicAnalysisResults",
        ):
            self._parent = parent

        @property
        def abstract_analysis_options(
            self: "SpeedOptionsForHarmonicAnalysisResults._Cast_SpeedOptionsForHarmonicAnalysisResults",
        ) -> "_7538.AbstractAnalysisOptions":
            return self._parent._cast(_7538.AbstractAnalysisOptions)

        @property
        def speed_options_for_harmonic_analysis_results(
            self: "SpeedOptionsForHarmonicAnalysisResults._Cast_SpeedOptionsForHarmonicAnalysisResults",
        ) -> "SpeedOptionsForHarmonicAnalysisResults":
            return self._parent

        def __getattr__(
            self: "SpeedOptionsForHarmonicAnalysisResults._Cast_SpeedOptionsForHarmonicAnalysisResults",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "SpeedOptionsForHarmonicAnalysisResults.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def maximum(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.Maximum

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @maximum.setter
    @enforce_parameter_types
    def maximum(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.Maximum = value

    @property
    def minimum(self: Self) -> "float":
        """float"""
        temp = self.wrapped.Minimum

        if temp is None:
            return 0.0

        return temp

    @minimum.setter
    @enforce_parameter_types
    def minimum(self: Self, value: "float"):
        self.wrapped.Minimum = float(value) if value is not None else 0.0

    @property
    def number_of_speeds(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfSpeeds

        if temp is None:
            return 0

        return temp

    @number_of_speeds.setter
    @enforce_parameter_types
    def number_of_speeds(self: Self, value: "int"):
        self.wrapped.NumberOfSpeeds = int(value) if value is not None else 0

    @property
    def reference_power_load_speed(self: Self) -> "float":
        """float"""
        temp = self.wrapped.ReferencePowerLoadSpeed

        if temp is None:
            return 0.0

        return temp

    @reference_power_load_speed.setter
    @enforce_parameter_types
    def reference_power_load_speed(self: Self, value: "float"):
        self.wrapped.ReferencePowerLoadSpeed = (
            float(value) if value is not None else 0.0
        )

    @property
    def show_result_in_time_domain(self: Self) -> "bool":
        """bool"""
        temp = self.wrapped.ShowResultInTimeDomain

        if temp is None:
            return False

        return temp

    @show_result_in_time_domain.setter
    @enforce_parameter_types
    def show_result_in_time_domain(self: Self, value: "bool"):
        self.wrapped.ShowResultInTimeDomain = (
            bool(value) if value is not None else False
        )

    @property
    def report_names(self: Self) -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ReportNames

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else "")

    def get_default_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else "")

    @enforce_parameter_types
    def output_active_report_as_text_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else "")

    def get_active_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_named_report_to(self: Self, report_name: "str", file_path: "str"):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: Self, report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(
            report_name if report_name else ""
        )
        return method_result

    @property
    def cast_to(
        self: Self,
    ) -> "SpeedOptionsForHarmonicAnalysisResults._Cast_SpeedOptionsForHarmonicAnalysisResults":
        return self._Cast_SpeedOptionsForHarmonicAnalysisResults(self)
