"""ComponentMeasurer"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_COMPONENT_MEASURER = python_net_import(
    "SMT.MastaAPI.SystemModel.ConnectionsAndSockets", "ComponentMeasurer"
)

if TYPE_CHECKING:
    from mastapy.system_model.part_model import _2446
    from mastapy.system_model.connections_and_sockets import _2272, _2277, _2279


__docformat__ = "restructuredtext en"
__all__ = ("ComponentMeasurer",)


Self = TypeVar("Self", bound="ComponentMeasurer")


class ComponentMeasurer(_0.APIBase):
    """ComponentMeasurer

    This is a mastapy class.
    """

    TYPE = _COMPONENT_MEASURER
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_ComponentMeasurer")

    class _Cast_ComponentMeasurer:
        """Special nested class for casting ComponentMeasurer to subclasses."""

        def __init__(
            self: "ComponentMeasurer._Cast_ComponentMeasurer",
            parent: "ComponentMeasurer",
        ):
            self._parent = parent

        @property
        def component_connection(
            self: "ComponentMeasurer._Cast_ComponentMeasurer",
        ) -> "_2272.ComponentConnection":
            from mastapy.system_model.connections_and_sockets import _2272

            return self._parent._cast(_2272.ComponentConnection)

        @property
        def cylindrical_component_connection(
            self: "ComponentMeasurer._Cast_ComponentMeasurer",
        ) -> "_2277.CylindricalComponentConnection":
            from mastapy.system_model.connections_and_sockets import _2277

            return self._parent._cast(_2277.CylindricalComponentConnection)

        @property
        def datum_measurement(
            self: "ComponentMeasurer._Cast_ComponentMeasurer",
        ) -> "_2279.DatumMeasurement":
            from mastapy.system_model.connections_and_sockets import _2279

            return self._parent._cast(_2279.DatumMeasurement)

        @property
        def component_measurer(
            self: "ComponentMeasurer._Cast_ComponentMeasurer",
        ) -> "ComponentMeasurer":
            return self._parent

        def __getattr__(self: "ComponentMeasurer._Cast_ComponentMeasurer", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "ComponentMeasurer.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def offset_of_component(self: Self) -> "float":
        """float"""
        temp = self.wrapped.OffsetOfComponent

        if temp is None:
            return 0.0

        return temp

    @offset_of_component.setter
    @enforce_parameter_types
    def offset_of_component(self: Self, value: "float"):
        self.wrapped.OffsetOfComponent = float(value) if value is not None else 0.0

    @property
    def component(self: Self) -> "_2446.Component":
        """mastapy.system_model.part_model.Component

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Component

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def report_names(self: Self) -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ReportNames

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else "")

    def get_default_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else "")

    @enforce_parameter_types
    def output_active_report_as_text_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else "")

    def get_active_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_named_report_to(self: Self, report_name: "str", file_path: "str"):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: Self, report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(
            report_name if report_name else ""
        )
        return method_result

    @property
    def cast_to(self: Self) -> "ComponentMeasurer._Cast_ComponentMeasurer":
        return self._Cast_ComponentMeasurer(self)
