"""AssemblyLoadCase"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal import constructor, conversion
from mastapy.system_model.analyses_and_results.static_loads import _6809
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_ASSEMBLY_LOAD_CASE = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.StaticLoads", "AssemblyLoadCase"
)

if TYPE_CHECKING:
    from mastapy.system_model.part_model import _2435
    from mastapy.gears.analysis import _1228
    from mastapy.system_model.analyses_and_results.static_loads import (
        _6822,
        _6824,
        _6827,
        _6833,
        _6834,
        _6858,
        _6835,
        _6837,
        _6843,
        _6846,
        _6860,
        _6862,
        _6868,
        _6890,
        _6889,
        _6891,
        _6895,
        _6910,
        _6920,
        _6923,
        _6924,
        _6925,
        _6929,
        _6934,
        _6938,
        _6941,
        _6942,
        _6946,
        _6947,
        _6948,
        _6952,
        _6953,
        _6811,
        _6958,
        _6961,
        _6964,
        _6967,
        _6971,
        _6976,
        _6983,
        _6987,
        _6990,
        _6951,
        _6931,
    )
    from mastapy.system_model.analyses_and_results import _2659, _2655, _2653


__docformat__ = "restructuredtext en"
__all__ = ("AssemblyLoadCase",)


Self = TypeVar("Self", bound="AssemblyLoadCase")


class AssemblyLoadCase(_6809.AbstractAssemblyLoadCase):
    """AssemblyLoadCase

    This is a mastapy class.
    """

    TYPE = _ASSEMBLY_LOAD_CASE
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_AssemblyLoadCase")

    class _Cast_AssemblyLoadCase:
        """Special nested class for casting AssemblyLoadCase to subclasses."""

        def __init__(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase", parent: "AssemblyLoadCase"
        ):
            self._parent = parent

        @property
        def abstract_assembly_load_case(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_6809.AbstractAssemblyLoadCase":
            return self._parent._cast(_6809.AbstractAssemblyLoadCase)

        @property
        def part_load_case(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_6931.PartLoadCase":
            from mastapy.system_model.analyses_and_results.static_loads import _6931

            return self._parent._cast(_6931.PartLoadCase)

        @property
        def part_analysis(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_2659.PartAnalysis":
            from mastapy.system_model.analyses_and_results import _2659

            return self._parent._cast(_2659.PartAnalysis)

        @property
        def design_entity_single_context_analysis(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_2655.DesignEntitySingleContextAnalysis":
            from mastapy.system_model.analyses_and_results import _2655

            return self._parent._cast(_2655.DesignEntitySingleContextAnalysis)

        @property
        def design_entity_analysis(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_2653.DesignEntityAnalysis":
            from mastapy.system_model.analyses_and_results import _2653

            return self._parent._cast(_2653.DesignEntityAnalysis)

        @property
        def root_assembly_load_case(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "_6951.RootAssemblyLoadCase":
            from mastapy.system_model.analyses_and_results.static_loads import _6951

            return self._parent._cast(_6951.RootAssemblyLoadCase)

        @property
        def assembly_load_case(
            self: "AssemblyLoadCase._Cast_AssemblyLoadCase",
        ) -> "AssemblyLoadCase":
            return self._parent

        def __getattr__(self: "AssemblyLoadCase._Cast_AssemblyLoadCase", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "AssemblyLoadCase.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def assembly_design(self: Self) -> "_2435.Assembly":
        """mastapy.system_model.part_model.Assembly

        Note:
            This property is readonly.
        """
        temp = self.wrapped.AssemblyDesign

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def rating_for_all_gear_sets(self: Self) -> "_1228.GearSetGroupDutyCycle":
        """mastapy.gears.analysis.GearSetGroupDutyCycle

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RatingForAllGearSets

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def bearings(self: Self) -> "List[_6822.BearingLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.BearingLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Bearings

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def belt_drives(self: Self) -> "List[_6824.BeltDriveLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.BeltDriveLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.BeltDrives

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def bevel_differential_gear_sets(
        self: Self,
    ) -> "List[_6827.BevelDifferentialGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.BevelDifferentialGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.BevelDifferentialGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def bolted_joints(self: Self) -> "List[_6833.BoltedJointLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.BoltedJointLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.BoltedJoints

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def bolts(self: Self) -> "List[_6834.BoltLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.BoltLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Bolts

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cv_ts(self: Self) -> "List[_6858.CVTLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.CVTLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.CVTs

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def clutch_connections(self: Self) -> "List[_6835.ClutchConnectionLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ClutchConnectionLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ClutchConnections

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def clutches(self: Self) -> "List[_6837.ClutchLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ClutchLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Clutches

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def concept_couplings(self: Self) -> "List[_6843.ConceptCouplingLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ConceptCouplingLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ConceptCouplings

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def concept_gear_sets(self: Self) -> "List[_6846.ConceptGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ConceptGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ConceptGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cycloidal_assemblies(self: Self) -> "List[_6860.CycloidalAssemblyLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.CycloidalAssemblyLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.CycloidalAssemblies

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cycloidal_discs(self: Self) -> "List[_6862.CycloidalDiscLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.CycloidalDiscLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.CycloidalDiscs

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cylindrical_gear_sets(self: Self) -> "List[_6868.CylindricalGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.CylindricalGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.CylindricalGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def fe_parts(self: Self) -> "List[_6890.FEPartLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.FEPartLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.FEParts

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def face_gear_sets(self: Self) -> "List[_6889.FaceGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.FaceGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.FaceGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def flexible_pin_assemblies(
        self: Self,
    ) -> "List[_6891.FlexiblePinAssemblyLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.FlexiblePinAssemblyLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.FlexiblePinAssemblies

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def gear_meshes(self: Self) -> "List[_6895.GearMeshLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.GearMeshLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.GearMeshes

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def hypoid_gear_sets(self: Self) -> "List[_6910.HypoidGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.HypoidGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.HypoidGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def klingelnberg_cyclo_palloid_hypoid_gear_sets(
        self: Self,
    ) -> "List[_6920.KlingelnbergCycloPalloidHypoidGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.KlingelnbergCycloPalloidHypoidGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.KlingelnbergCycloPalloidHypoidGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def klingelnberg_cyclo_palloid_spiral_bevel_gear_sets(
        self: Self,
    ) -> "List[_6923.KlingelnbergCycloPalloidSpiralBevelGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.KlingelnbergCycloPalloidSpiralBevelGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.KlingelnbergCycloPalloidSpiralBevelGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def mass_discs(self: Self) -> "List[_6924.MassDiscLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.MassDiscLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MassDiscs

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def measurement_components(
        self: Self,
    ) -> "List[_6925.MeasurementComponentLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.MeasurementComponentLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.MeasurementComponents

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def oil_seals(self: Self) -> "List[_6929.OilSealLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.OilSealLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.OilSeals

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def part_to_part_shear_couplings(
        self: Self,
    ) -> "List[_6934.PartToPartShearCouplingLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.PartToPartShearCouplingLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PartToPartShearCouplings

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def planet_carriers(self: Self) -> "List[_6938.PlanetCarrierLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.PlanetCarrierLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PlanetCarriers

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def point_loads(self: Self) -> "List[_6941.PointLoadLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.PointLoadLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PointLoads

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def power_loads(self: Self) -> "List[_6942.PowerLoadLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.PowerLoadLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PowerLoads

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def ring_pins(self: Self) -> "List[_6946.RingPinsLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.RingPinsLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RingPins

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def ring_pins_to_cycloidal_disc_connections(
        self: Self,
    ) -> "List[_6947.RingPinsToDiscConnectionLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.RingPinsToDiscConnectionLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RingPinsToCycloidalDiscConnections

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def rolling_ring_assemblies(
        self: Self,
    ) -> "List[_6948.RollingRingAssemblyLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.RollingRingAssemblyLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.RollingRingAssemblies

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def shaft_hub_connections(self: Self) -> "List[_6952.ShaftHubConnectionLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ShaftHubConnectionLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ShaftHubConnections

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def shafts(self: Self) -> "List[_6953.ShaftLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ShaftLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Shafts

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def shafts_and_housings(self: Self) -> "List[_6811.AbstractShaftOrHousingLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.AbstractShaftOrHousingLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ShaftsAndHousings

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def spiral_bevel_gear_sets(self: Self) -> "List[_6958.SpiralBevelGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.SpiralBevelGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.SpiralBevelGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def spring_dampers(self: Self) -> "List[_6961.SpringDamperLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.SpringDamperLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.SpringDampers

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def straight_bevel_diff_gear_sets(
        self: Self,
    ) -> "List[_6964.StraightBevelDiffGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.StraightBevelDiffGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.StraightBevelDiffGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def straight_bevel_gear_sets(
        self: Self,
    ) -> "List[_6967.StraightBevelGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.StraightBevelGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.StraightBevelGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def synchronisers(self: Self) -> "List[_6971.SynchroniserLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.SynchroniserLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Synchronisers

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def torque_converters(self: Self) -> "List[_6976.TorqueConverterLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.TorqueConverterLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.TorqueConverters

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def unbalanced_masses(self: Self) -> "List[_6983.UnbalancedMassLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.UnbalancedMassLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.UnbalancedMasses

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def worm_gear_sets(self: Self) -> "List[_6987.WormGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.WormGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.WormGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def zerol_bevel_gear_sets(self: Self) -> "List[_6990.ZerolBevelGearSetLoadCase]":
        """List[mastapy.system_model.analyses_and_results.static_loads.ZerolBevelGearSetLoadCase]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ZerolBevelGearSets

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cast_to(self: Self) -> "AssemblyLoadCase._Cast_AssemblyLoadCase":
        return self._Cast_AssemblyLoadCase(self)
