from enum import Enum


class RequestStatus(str, Enum):
    SUCCESS = "SUCCESS"
    FAILURE_DO_NOT_RETRY = "FAILURE_DO_NOT_RETRY"
    FAILURE_RETRY_SUGGESTED = "FAILURE_RETRY_SUGGESTED"
    FAILURE_RETRIES_EXHAUSTED = "FAILURE_RETRIES_EXHAUSTED"
    OPERATION_FAILED_BUT_NO_LONGER_REQUIRED = "OPERATION_FAILED_BUT_NO_LONGER_REQUIRED"

    def is_permanent_failure(self):
        return self.value in [RequestStatus.FAILURE_RETRIES_EXHAUSTED, RequestStatus.FAILURE_DO_NOT_RETRY]