# Generated by Django 4.2.13 on 2024-05-21 21:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="RequestAuditEvent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "extra_informations",
                    models.TextField(
                        blank=True, null=True, verbose_name="Extra information"
                    ),
                ),
                (
                    "datetime",
                    models.DateTimeField(auto_now_add=True, verbose_name="Datetime"),
                ),
                (
                    "ip_addresses",
                    models.CharField(
                        max_length=50, null=True, verbose_name="Ip addresses"
                    ),
                ),
                ("method", models.CharField(max_length=10, verbose_name="Method")),
                ("url", models.CharField(max_length=2048, verbose_name="URL")),
                (
                    "query_params",
                    models.CharField(
                        blank=True,
                        max_length=2048,
                        null=True,
                        verbose_name="Query Parameters",
                    ),
                ),
                (
                    "request_type",
                    models.CharField(
                        blank=True,
                        max_length=10,
                        null=True,
                        verbose_name="Request Type",
                    ),
                ),
                (
                    "status_code",
                    models.IntegerField(null=True, verbose_name="Status Code"),
                ),
                (
                    "response_time",
                    models.FloatField(null=True, verbose_name="Response Time (ms)"),
                ),
                (
                    "response_size",
                    models.IntegerField(
                        null=True, verbose_name="Response Size (bytes)"
                    ),
                ),
                (
                    "error_type",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Error Type"
                    ),
                ),
                (
                    "error_message",
                    models.TextField(
                        blank=True, null=True, verbose_name="Error Message"
                    ),
                ),
                (
                    "error_stacktrace",
                    models.TextField(
                        blank=True, null=True, verbose_name="Error Stacktrace"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Request event",
                "verbose_name_plural": "Request events",
                "db_table": "request_audit_event",
            },
        ),
        migrations.CreateModel(
            name="LoginAuditEvent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "extra_informations",
                    models.TextField(
                        blank=True, null=True, verbose_name="Extra information"
                    ),
                ),
                (
                    "datetime",
                    models.DateTimeField(auto_now_add=True, verbose_name="Datetime"),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Sign in", "Sign in"),
                            ("Sign out", "Sign out"),
                            ("Failed", "Failed"),
                        ],
                        max_length=8,
                        verbose_name="Status",
                    ),
                ),
                (
                    "request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="drf_audit_trail.requestauditevent",
                    ),
                ),
            ],
            options={
                "verbose_name": "Login audit event",
                "verbose_name_plural": "Login audit events",
                "db_table": "login_audit_event",
            },
        ),
    ]
