# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_slims_service_client.models.histology_wash_data import HistologyWashData
from typing import Optional, Set
from typing_extensions import Self

class SlimsHistologyData(BaseModel):
    """
    Expected Model that needs to be extracted from SLIMS.
    """ # noqa: E501
    procedure_name: Optional[StrictStr] = None
    experiment_run_created_on: Optional[datetime] = None
    specimen_id: Optional[StrictStr] = None
    subject_id: Optional[StrictStr] = None
    protocol_id: Optional[StrictStr] = None
    protocol_name: Optional[StrictStr] = None
    washes: Optional[List[HistologyWashData]] = None
    __properties: ClassVar[List[str]] = ["procedure_name", "experiment_run_created_on", "specimen_id", "subject_id", "protocol_id", "protocol_name", "washes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlimsHistologyData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in washes (list)
        _items = []
        if self.washes:
            for _item_washes in self.washes:
                if _item_washes:
                    _items.append(_item_washes.to_dict())
            _dict['washes'] = _items
        # set to None if procedure_name (nullable) is None
        # and model_fields_set contains the field
        if self.procedure_name is None and "procedure_name" in self.model_fields_set:
            _dict['procedure_name'] = None

        # set to None if experiment_run_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.experiment_run_created_on is None and "experiment_run_created_on" in self.model_fields_set:
            _dict['experiment_run_created_on'] = None

        # set to None if specimen_id (nullable) is None
        # and model_fields_set contains the field
        if self.specimen_id is None and "specimen_id" in self.model_fields_set:
            _dict['specimen_id'] = None

        # set to None if subject_id (nullable) is None
        # and model_fields_set contains the field
        if self.subject_id is None and "subject_id" in self.model_fields_set:
            _dict['subject_id'] = None

        # set to None if protocol_id (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_id is None and "protocol_id" in self.model_fields_set:
            _dict['protocol_id'] = None

        # set to None if protocol_name (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_name is None and "protocol_name" in self.model_fields_set:
            _dict['protocol_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlimsHistologyData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "procedure_name": obj.get("procedure_name"),
            "experiment_run_created_on": obj.get("experiment_run_created_on"),
            "specimen_id": obj.get("specimen_id"),
            "subject_id": obj.get("subject_id"),
            "protocol_id": obj.get("protocol_id"),
            "protocol_name": obj.get("protocol_name"),
            "washes": [HistologyWashData.from_dict(_item) for _item in obj["washes"]] if obj.get("washes") is not None else None
        })
        return _obj


