# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_slims_service_client.models.slims_viral_material_data import SlimsViralMaterialData
from typing import Optional, Set
from typing_extensions import Self

class SlimsViralInjectionData(BaseModel):
    """
    \"Model for viral injection data.
    """ # noqa: E501
    content_category: Optional[StrictStr] = None
    content_type: Optional[StrictStr] = None
    content_created_on: Optional[datetime] = None
    content_modified_on: Optional[datetime] = None
    name: Optional[StrictStr] = None
    viral_injection_buffer: Optional[StrictStr] = None
    volume: Optional[StrictStr] = None
    volume_unit: Optional[StrictStr] = None
    labeling_protein: Optional[StrictStr] = None
    date_made: Optional[datetime] = None
    intake_date: Optional[datetime] = None
    storage_temperature: Optional[StrictStr] = None
    special_storage_guidelines: Optional[List[StrictStr]] = None
    special_handling_guidelines: Optional[List[StrictStr]] = None
    mix_count: Optional[StrictInt] = None
    derivation_count: Optional[StrictInt] = None
    ingredient_count: Optional[StrictInt] = None
    assigned_mice: Optional[List[StrictStr]] = None
    requested_for_date: Optional[StrictInt] = None
    planned_injection_date: Optional[datetime] = None
    planned_injection_time: Optional[datetime] = None
    order_created_on: Optional[datetime] = None
    viral_materials: Optional[List[SlimsViralMaterialData]] = None
    __properties: ClassVar[List[str]] = ["content_category", "content_type", "content_created_on", "content_modified_on", "name", "viral_injection_buffer", "volume", "volume_unit", "labeling_protein", "date_made", "intake_date", "storage_temperature", "special_storage_guidelines", "special_handling_guidelines", "mix_count", "derivation_count", "ingredient_count", "assigned_mice", "requested_for_date", "planned_injection_date", "planned_injection_time", "order_created_on", "viral_materials"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlimsViralInjectionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in viral_materials (list)
        _items = []
        if self.viral_materials:
            for _item_viral_materials in self.viral_materials:
                if _item_viral_materials:
                    _items.append(_item_viral_materials.to_dict())
            _dict['viral_materials'] = _items
        # set to None if content_category (nullable) is None
        # and model_fields_set contains the field
        if self.content_category is None and "content_category" in self.model_fields_set:
            _dict['content_category'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if content_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.content_created_on is None and "content_created_on" in self.model_fields_set:
            _dict['content_created_on'] = None

        # set to None if content_modified_on (nullable) is None
        # and model_fields_set contains the field
        if self.content_modified_on is None and "content_modified_on" in self.model_fields_set:
            _dict['content_modified_on'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if viral_injection_buffer (nullable) is None
        # and model_fields_set contains the field
        if self.viral_injection_buffer is None and "viral_injection_buffer" in self.model_fields_set:
            _dict['viral_injection_buffer'] = None

        # set to None if volume (nullable) is None
        # and model_fields_set contains the field
        if self.volume is None and "volume" in self.model_fields_set:
            _dict['volume'] = None

        # set to None if volume_unit (nullable) is None
        # and model_fields_set contains the field
        if self.volume_unit is None and "volume_unit" in self.model_fields_set:
            _dict['volume_unit'] = None

        # set to None if labeling_protein (nullable) is None
        # and model_fields_set contains the field
        if self.labeling_protein is None and "labeling_protein" in self.model_fields_set:
            _dict['labeling_protein'] = None

        # set to None if date_made (nullable) is None
        # and model_fields_set contains the field
        if self.date_made is None and "date_made" in self.model_fields_set:
            _dict['date_made'] = None

        # set to None if intake_date (nullable) is None
        # and model_fields_set contains the field
        if self.intake_date is None and "intake_date" in self.model_fields_set:
            _dict['intake_date'] = None

        # set to None if storage_temperature (nullable) is None
        # and model_fields_set contains the field
        if self.storage_temperature is None and "storage_temperature" in self.model_fields_set:
            _dict['storage_temperature'] = None

        # set to None if special_storage_guidelines (nullable) is None
        # and model_fields_set contains the field
        if self.special_storage_guidelines is None and "special_storage_guidelines" in self.model_fields_set:
            _dict['special_storage_guidelines'] = None

        # set to None if special_handling_guidelines (nullable) is None
        # and model_fields_set contains the field
        if self.special_handling_guidelines is None and "special_handling_guidelines" in self.model_fields_set:
            _dict['special_handling_guidelines'] = None

        # set to None if mix_count (nullable) is None
        # and model_fields_set contains the field
        if self.mix_count is None and "mix_count" in self.model_fields_set:
            _dict['mix_count'] = None

        # set to None if derivation_count (nullable) is None
        # and model_fields_set contains the field
        if self.derivation_count is None and "derivation_count" in self.model_fields_set:
            _dict['derivation_count'] = None

        # set to None if ingredient_count (nullable) is None
        # and model_fields_set contains the field
        if self.ingredient_count is None and "ingredient_count" in self.model_fields_set:
            _dict['ingredient_count'] = None

        # set to None if assigned_mice (nullable) is None
        # and model_fields_set contains the field
        if self.assigned_mice is None and "assigned_mice" in self.model_fields_set:
            _dict['assigned_mice'] = None

        # set to None if requested_for_date (nullable) is None
        # and model_fields_set contains the field
        if self.requested_for_date is None and "requested_for_date" in self.model_fields_set:
            _dict['requested_for_date'] = None

        # set to None if planned_injection_date (nullable) is None
        # and model_fields_set contains the field
        if self.planned_injection_date is None and "planned_injection_date" in self.model_fields_set:
            _dict['planned_injection_date'] = None

        # set to None if planned_injection_time (nullable) is None
        # and model_fields_set contains the field
        if self.planned_injection_time is None and "planned_injection_time" in self.model_fields_set:
            _dict['planned_injection_time'] = None

        # set to None if order_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.order_created_on is None and "order_created_on" in self.model_fields_set:
            _dict['order_created_on'] = None

        # set to None if viral_materials (nullable) is None
        # and model_fields_set contains the field
        if self.viral_materials is None and "viral_materials" in self.model_fields_set:
            _dict['viral_materials'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlimsViralInjectionData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_category": obj.get("content_category"),
            "content_type": obj.get("content_type"),
            "content_created_on": obj.get("content_created_on"),
            "content_modified_on": obj.get("content_modified_on"),
            "name": obj.get("name"),
            "viral_injection_buffer": obj.get("viral_injection_buffer"),
            "volume": obj.get("volume"),
            "volume_unit": obj.get("volume_unit"),
            "labeling_protein": obj.get("labeling_protein"),
            "date_made": obj.get("date_made"),
            "intake_date": obj.get("intake_date"),
            "storage_temperature": obj.get("storage_temperature"),
            "special_storage_guidelines": obj.get("special_storage_guidelines"),
            "special_handling_guidelines": obj.get("special_handling_guidelines"),
            "mix_count": obj.get("mix_count"),
            "derivation_count": obj.get("derivation_count"),
            "ingredient_count": obj.get("ingredient_count"),
            "assigned_mice": obj.get("assigned_mice"),
            "requested_for_date": obj.get("requested_for_date"),
            "planned_injection_date": obj.get("planned_injection_date"),
            "planned_injection_time": obj.get("planned_injection_time"),
            "order_created_on": obj.get("order_created_on"),
            "viral_materials": [SlimsViralMaterialData.from_dict(_item) for _item in obj["viral_materials"]] if obj.get("viral_materials") is not None else None
        })
        return _obj


