# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SlimsViralMaterialData(BaseModel):
    """
    Model for viral material data.
    """ # noqa: E501
    content_category: Optional[StrictStr] = None
    content_type: Optional[StrictStr] = None
    content_created_on: Optional[datetime] = None
    content_modified_on: Optional[datetime] = None
    viral_solution_type: Optional[StrictStr] = None
    virus_name: Optional[StrictStr] = None
    lot_number: Optional[StrictStr] = None
    lab_team: Optional[StrictStr] = None
    virus_type: Optional[StrictStr] = None
    virus_serotype: Optional[StrictStr] = None
    virus_plasmid_number: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    dose: Optional[StrictStr] = None
    dose_unit: Optional[StrictStr] = None
    titer: Optional[StrictStr] = None
    titer_unit: Optional[StrictStr] = None
    volume: Optional[StrictStr] = None
    volume_unit: Optional[StrictStr] = None
    date_made: Optional[datetime] = None
    intake_date: Optional[datetime] = None
    storage_temperature: Optional[StrictStr] = None
    special_storage_guidelines: Optional[List[StrictStr]] = None
    special_handling_guidelines: Optional[List[StrictStr]] = None
    parent_name: Optional[StrictStr] = None
    mix_count: Optional[StrictInt] = None
    derivation_count: Optional[StrictInt] = None
    ingredient_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["content_category", "content_type", "content_created_on", "content_modified_on", "viral_solution_type", "virus_name", "lot_number", "lab_team", "virus_type", "virus_serotype", "virus_plasmid_number", "name", "dose", "dose_unit", "titer", "titer_unit", "volume", "volume_unit", "date_made", "intake_date", "storage_temperature", "special_storage_guidelines", "special_handling_guidelines", "parent_name", "mix_count", "derivation_count", "ingredient_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlimsViralMaterialData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if content_category (nullable) is None
        # and model_fields_set contains the field
        if self.content_category is None and "content_category" in self.model_fields_set:
            _dict['content_category'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if content_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.content_created_on is None and "content_created_on" in self.model_fields_set:
            _dict['content_created_on'] = None

        # set to None if content_modified_on (nullable) is None
        # and model_fields_set contains the field
        if self.content_modified_on is None and "content_modified_on" in self.model_fields_set:
            _dict['content_modified_on'] = None

        # set to None if viral_solution_type (nullable) is None
        # and model_fields_set contains the field
        if self.viral_solution_type is None and "viral_solution_type" in self.model_fields_set:
            _dict['viral_solution_type'] = None

        # set to None if virus_name (nullable) is None
        # and model_fields_set contains the field
        if self.virus_name is None and "virus_name" in self.model_fields_set:
            _dict['virus_name'] = None

        # set to None if lot_number (nullable) is None
        # and model_fields_set contains the field
        if self.lot_number is None and "lot_number" in self.model_fields_set:
            _dict['lot_number'] = None

        # set to None if lab_team (nullable) is None
        # and model_fields_set contains the field
        if self.lab_team is None and "lab_team" in self.model_fields_set:
            _dict['lab_team'] = None

        # set to None if virus_type (nullable) is None
        # and model_fields_set contains the field
        if self.virus_type is None and "virus_type" in self.model_fields_set:
            _dict['virus_type'] = None

        # set to None if virus_serotype (nullable) is None
        # and model_fields_set contains the field
        if self.virus_serotype is None and "virus_serotype" in self.model_fields_set:
            _dict['virus_serotype'] = None

        # set to None if virus_plasmid_number (nullable) is None
        # and model_fields_set contains the field
        if self.virus_plasmid_number is None and "virus_plasmid_number" in self.model_fields_set:
            _dict['virus_plasmid_number'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if dose (nullable) is None
        # and model_fields_set contains the field
        if self.dose is None and "dose" in self.model_fields_set:
            _dict['dose'] = None

        # set to None if dose_unit (nullable) is None
        # and model_fields_set contains the field
        if self.dose_unit is None and "dose_unit" in self.model_fields_set:
            _dict['dose_unit'] = None

        # set to None if titer (nullable) is None
        # and model_fields_set contains the field
        if self.titer is None and "titer" in self.model_fields_set:
            _dict['titer'] = None

        # set to None if titer_unit (nullable) is None
        # and model_fields_set contains the field
        if self.titer_unit is None and "titer_unit" in self.model_fields_set:
            _dict['titer_unit'] = None

        # set to None if volume (nullable) is None
        # and model_fields_set contains the field
        if self.volume is None and "volume" in self.model_fields_set:
            _dict['volume'] = None

        # set to None if volume_unit (nullable) is None
        # and model_fields_set contains the field
        if self.volume_unit is None and "volume_unit" in self.model_fields_set:
            _dict['volume_unit'] = None

        # set to None if date_made (nullable) is None
        # and model_fields_set contains the field
        if self.date_made is None and "date_made" in self.model_fields_set:
            _dict['date_made'] = None

        # set to None if intake_date (nullable) is None
        # and model_fields_set contains the field
        if self.intake_date is None and "intake_date" in self.model_fields_set:
            _dict['intake_date'] = None

        # set to None if storage_temperature (nullable) is None
        # and model_fields_set contains the field
        if self.storage_temperature is None and "storage_temperature" in self.model_fields_set:
            _dict['storage_temperature'] = None

        # set to None if special_storage_guidelines (nullable) is None
        # and model_fields_set contains the field
        if self.special_storage_guidelines is None and "special_storage_guidelines" in self.model_fields_set:
            _dict['special_storage_guidelines'] = None

        # set to None if special_handling_guidelines (nullable) is None
        # and model_fields_set contains the field
        if self.special_handling_guidelines is None and "special_handling_guidelines" in self.model_fields_set:
            _dict['special_handling_guidelines'] = None

        # set to None if parent_name (nullable) is None
        # and model_fields_set contains the field
        if self.parent_name is None and "parent_name" in self.model_fields_set:
            _dict['parent_name'] = None

        # set to None if mix_count (nullable) is None
        # and model_fields_set contains the field
        if self.mix_count is None and "mix_count" in self.model_fields_set:
            _dict['mix_count'] = None

        # set to None if derivation_count (nullable) is None
        # and model_fields_set contains the field
        if self.derivation_count is None and "derivation_count" in self.model_fields_set:
            _dict['derivation_count'] = None

        # set to None if ingredient_count (nullable) is None
        # and model_fields_set contains the field
        if self.ingredient_count is None and "ingredient_count" in self.model_fields_set:
            _dict['ingredient_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlimsViralMaterialData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_category": obj.get("content_category"),
            "content_type": obj.get("content_type"),
            "content_created_on": obj.get("content_created_on"),
            "content_modified_on": obj.get("content_modified_on"),
            "viral_solution_type": obj.get("viral_solution_type"),
            "virus_name": obj.get("virus_name"),
            "lot_number": obj.get("lot_number"),
            "lab_team": obj.get("lab_team"),
            "virus_type": obj.get("virus_type"),
            "virus_serotype": obj.get("virus_serotype"),
            "virus_plasmid_number": obj.get("virus_plasmid_number"),
            "name": obj.get("name"),
            "dose": obj.get("dose"),
            "dose_unit": obj.get("dose_unit"),
            "titer": obj.get("titer"),
            "titer_unit": obj.get("titer_unit"),
            "volume": obj.get("volume"),
            "volume_unit": obj.get("volume_unit"),
            "date_made": obj.get("date_made"),
            "intake_date": obj.get("intake_date"),
            "storage_temperature": obj.get("storage_temperature"),
            "special_storage_guidelines": obj.get("special_storage_guidelines"),
            "special_handling_guidelines": obj.get("special_handling_guidelines"),
            "parent_name": obj.get("parent_name"),
            "mix_count": obj.get("mix_count"),
            "derivation_count": obj.get("derivation_count"),
            "ingredient_count": obj.get("ingredient_count")
        })
        return _obj


