# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.entity_error_type import EntityErrorType
from vrt_lss_agro.models.entity_path import EntityPath

class EntityError(BaseModel):
    """
    Description of the error in the input data.
    """
    type: EntityErrorType = ...
    info: Optional[constr(strict=True, max_length=2048, min_length=0)] = Field(None, description="Information about error.")
    entities: conlist(EntityPath, max_items=100001, min_items=0) = Field(..., description="List of entities related to error.")
    __properties = ["type", "info", "entities"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityError:
        """Create an instance of EntityError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in entities (list)
        _items = []
        if self.entities:
            for _item in self.entities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['entities'] = _items
        # set to None if info (nullable) is None
        # and __fields_set__ contains the field
        if self.info is None and "info" in self.__fields_set__:
            _dict['info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityError:
        """Create an instance of EntityError from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityError.parse_obj(obj)

        _obj = EntityError.parse_obj({
            "type": obj.get("type"),
            "info": obj.get("info"),
            "entities": [EntityPath.from_dict(_item) for _item in obj.get("entities")] if obj.get("entities") is not None else None
        })
        return _obj

