# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, conint
from vrt_lss_agro.models.project_configuration import ProjectConfiguration

class ProjectSettings(BaseModel):
    """
    Project settings.
    """
    configuration: Optional[ProjectConfiguration] = None
    start_date: date = Field(..., description="Window start date in the YYYY-MM-DD format.")
    end_date: date = Field(..., description="Window end date in the YYYY-MM-DD format.")
    transport_capacity: Optional[conint(strict=True, le=80, ge=1)] = Field(23, description="The capacity of one transport is the unit of grain movement between objects, in tons.")
    __properties = ["configuration", "start_date", "end_date", "transport_capacity"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectSettings:
        """Create an instance of ProjectSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectSettings:
        """Create an instance of ProjectSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProjectSettings.parse_obj(obj)

        _obj = ProjectSettings.parse_obj({
            "configuration": obj.get("configuration"),
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "transport_capacity": obj.get("transport_capacity") if obj.get("transport_capacity") is not None else 23
        })
        return _obj

