# Copyright 2022 Expedia, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


from enum import Enum


class UpdateType(Enum):
    """Enum UpdateType:
    Attributes:
        ORDER_UPDATE(Enum): Transaction type associated with the update event.
        CHARGEBACK_FEEDBACK(Enum): Transaction type associated with the update event.
        INSULT_FEEDBACK(Enum): Transaction type associated with the update event.
        REFUND_UPDATE(Enum): Transaction type associated with the update event.
        PAYMENT_UPDATE(Enum): Transaction type associated with the update event.
    """
    ORDER_UPDATE = "ORDER_UPDATE"
    CHARGEBACK_FEEDBACK = "CHARGEBACK_FEEDBACK"
    INSULT_FEEDBACK = "INSULT_FEEDBACK"
    REFUND_UPDATE = "REFUND_UPDATE"
    PAYMENT_UPDATE = "PAYMENT_UPDATE"


