from plotly.basedatatypes import BaseTraceHierarchyType
import copy


class Projection(BaseTraceHierarchyType):

    # x
    # -
    @property
    def x(self):
        """
        The 'x' property is an instance of X
        that may be specified as:
          - An instance of plotly.graph_objs.scatter3d.projection.X
          - A dict of string/value properties that will be passed
            to the X constructor
    
            Supported dict properties:
                
                opacity
                    Sets the projection color.
                scale
                    Sets the scale factor determining the size of
                    the projection marker points.
                show
                    Sets whether or not projections are shown along
                    the x axis.

        Returns
        -------
        plotly.graph_objs.scatter3d.projection.X
        """
        return self['x']

    @x.setter
    def x(self, val):
        self['x'] = val

    # y
    # -
    @property
    def y(self):
        """
        The 'y' property is an instance of Y
        that may be specified as:
          - An instance of plotly.graph_objs.scatter3d.projection.Y
          - A dict of string/value properties that will be passed
            to the Y constructor
    
            Supported dict properties:
                
                opacity
                    Sets the projection color.
                scale
                    Sets the scale factor determining the size of
                    the projection marker points.
                show
                    Sets whether or not projections are shown along
                    the y axis.

        Returns
        -------
        plotly.graph_objs.scatter3d.projection.Y
        """
        return self['y']

    @y.setter
    def y(self, val):
        self['y'] = val

    # z
    # -
    @property
    def z(self):
        """
        The 'z' property is an instance of Z
        that may be specified as:
          - An instance of plotly.graph_objs.scatter3d.projection.Z
          - A dict of string/value properties that will be passed
            to the Z constructor
    
            Supported dict properties:
                
                opacity
                    Sets the projection color.
                scale
                    Sets the scale factor determining the size of
                    the projection marker points.
                show
                    Sets whether or not projections are shown along
                    the z axis.

        Returns
        -------
        plotly.graph_objs.scatter3d.projection.Z
        """
        return self['z']

    @z.setter
    def z(self, val):
        self['z'] = val

    # property parent name
    # --------------------
    @property
    def _parent_path_str(self):
        return 'scatter3d'

    # Self properties description
    # ---------------------------
    @property
    def _prop_descriptions(self):
        return """\
        x
            plotly.graph_objs.scatter3d.projection.X instance or
            dict with compatible properties
        y
            plotly.graph_objs.scatter3d.projection.Y instance or
            dict with compatible properties
        z
            plotly.graph_objs.scatter3d.projection.Z instance or
            dict with compatible properties
        """

    def __init__(self, arg=None, x=None, y=None, z=None, **kwargs):
        """
        Construct a new Projection object
        
        Parameters
        ----------
        arg
            dict of properties compatible with this constructor or
            an instance of plotly.graph_objs.scatter3d.Projection
        x
            plotly.graph_objs.scatter3d.projection.X instance or
            dict with compatible properties
        y
            plotly.graph_objs.scatter3d.projection.Y instance or
            dict with compatible properties
        z
            plotly.graph_objs.scatter3d.projection.Z instance or
            dict with compatible properties

        Returns
        -------
        Projection
        """
        super(Projection, self).__init__('projection')

        # Validate arg
        # ------------
        if arg is None:
            arg = {}
        elif isinstance(arg, self.__class__):
            arg = arg.to_plotly_json()
        elif isinstance(arg, dict):
            arg = copy.copy(arg)
        else:
            raise ValueError(
                """\
The first argument to the plotly.graph_objs.scatter3d.Projection 
constructor must be a dict or 
an instance of plotly.graph_objs.scatter3d.Projection"""
            )

        # Handle skip_invalid
        # -------------------
        self._skip_invalid = kwargs.pop('skip_invalid', False)

        # Import validators
        # -----------------
        from plotly.validators.scatter3d import (projection as v_projection)

        # Initialize validators
        # ---------------------
        self._validators['x'] = v_projection.XValidator()
        self._validators['y'] = v_projection.YValidator()
        self._validators['z'] = v_projection.ZValidator()

        # Populate data dict with properties
        # ----------------------------------
        _v = arg.pop('x', None)
        self['x'] = x if x is not None else _v
        _v = arg.pop('y', None)
        self['y'] = y if y is not None else _v
        _v = arg.pop('z', None)
        self['z'] = z if z is not None else _v

        # Process unknown kwargs
        # ----------------------
        self._process_kwargs(**dict(arg, **kwargs))

        # Reset skip_invalid
        # ------------------
        self._skip_invalid = False
