

import _plotly_utils.basevalidators


class YsrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(self, plotly_name='ysrc', parent_name='histogram', **kwargs):
        super(YsrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class YcalendarValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='ycalendar', parent_name='histogram', **kwargs
    ):
        super(YcalendarValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            values=kwargs.pop(
                'values', [
                    'gregorian', 'chinese', 'coptic', 'discworld', 'ethiopian',
                    'hebrew', 'islamic', 'julian', 'mayan', 'nanakshahi',
                    'nepali', 'persian', 'jalali', 'taiwan', 'thai',
                    'ummalqura'
                ]
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class YBinsValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(self, plotly_name='ybins', parent_name='histogram', **kwargs):
        super(YBinsValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'YBins'),
            data_docs=kwargs.pop(
                'data_docs', """
            end
                Sets the end value for the y axis bins. The
                last bin may not end exactly at this value, we
                increment the bin edge by `size` from `start`
                until we reach or exceed `end`. Defaults to the
                maximum data value. Like `start`, for dates use
                a date string, and for category data `end` is
                based on the category serial numbers.
            size
                Sets the size of each y axis bin. Default
                behavior: If `nbinsy` is 0 or omitted, we
                choose a nice round bin size such that the
                number of bins is about the same as the typical
                number of samples in each bin. If `nbinsy` is
                provided, we choose a nice round bin size
                giving no more than that many bins. For date
                data, use milliseconds or "M<n>" for months, as
                in `axis.dtick`. For category data, the number
                of categories to bin together (always defaults
                to 1). If multiple non-overlaying histograms
                share a subplot, the first explicit `size` is
                used and all others discarded. If no `size` is
                provided,the sample data from all traces is
                combined to determine `size` as described
                above.
            start
                Sets the starting value for the y axis bins.
                Defaults to the minimum data value, shifted
                down if necessary to make nice round values and
                to remove ambiguous bin edges. For example, if
                most of the data is integers we shift the bin
                edges 0.5 down, so a `size` of 5 would have a
                default `start` of -0.5, so it is clear that
                0-4 are in the first bin, 5-9 in the second,
                but continuous data gets a start of 0 and bins
                [0,5), [5,10) etc. Dates behave similarly, and
                `start` should be a date string. For category
                data, `start` is based on the category serial
                numbers, and defaults to -0.5. If multiple non-
                overlaying histograms share a subplot, the
                first explicit `start` is used exactly and all
                others are shifted down (if necessary) to
                differ from that one by an integer number of
                bins.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class YAxisValidator(_plotly_utils.basevalidators.SubplotidValidator):

    def __init__(self, plotly_name='yaxis', parent_name='histogram', **kwargs):
        super(YAxisValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            dflt=kwargs.pop('dflt', 'y'),
            edit_type=kwargs.pop('edit_type', 'calc+clearAxisTypes'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class YValidator(_plotly_utils.basevalidators.DataArrayValidator):

    def __init__(self, plotly_name='y', parent_name='histogram', **kwargs):
        super(YValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc+clearAxisTypes'),
            role=kwargs.pop('role', 'data'),
            **kwargs
        )


import _plotly_utils.basevalidators


class XsrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(self, plotly_name='xsrc', parent_name='histogram', **kwargs):
        super(XsrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class XcalendarValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='xcalendar', parent_name='histogram', **kwargs
    ):
        super(XcalendarValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            values=kwargs.pop(
                'values', [
                    'gregorian', 'chinese', 'coptic', 'discworld', 'ethiopian',
                    'hebrew', 'islamic', 'julian', 'mayan', 'nanakshahi',
                    'nepali', 'persian', 'jalali', 'taiwan', 'thai',
                    'ummalqura'
                ]
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class XBinsValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(self, plotly_name='xbins', parent_name='histogram', **kwargs):
        super(XBinsValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'XBins'),
            data_docs=kwargs.pop(
                'data_docs', """
            end
                Sets the end value for the x axis bins. The
                last bin may not end exactly at this value, we
                increment the bin edge by `size` from `start`
                until we reach or exceed `end`. Defaults to the
                maximum data value. Like `start`, for dates use
                a date string, and for category data `end` is
                based on the category serial numbers.
            size
                Sets the size of each x axis bin. Default
                behavior: If `nbinsx` is 0 or omitted, we
                choose a nice round bin size such that the
                number of bins is about the same as the typical
                number of samples in each bin. If `nbinsx` is
                provided, we choose a nice round bin size
                giving no more than that many bins. For date
                data, use milliseconds or "M<n>" for months, as
                in `axis.dtick`. For category data, the number
                of categories to bin together (always defaults
                to 1). If multiple non-overlaying histograms
                share a subplot, the first explicit `size` is
                used and all others discarded. If no `size` is
                provided,the sample data from all traces is
                combined to determine `size` as described
                above.
            start
                Sets the starting value for the x axis bins.
                Defaults to the minimum data value, shifted
                down if necessary to make nice round values and
                to remove ambiguous bin edges. For example, if
                most of the data is integers we shift the bin
                edges 0.5 down, so a `size` of 5 would have a
                default `start` of -0.5, so it is clear that
                0-4 are in the first bin, 5-9 in the second,
                but continuous data gets a start of 0 and bins
                [0,5), [5,10) etc. Dates behave similarly, and
                `start` should be a date string. For category
                data, `start` is based on the category serial
                numbers, and defaults to -0.5. If multiple non-
                overlaying histograms share a subplot, the
                first explicit `start` is used exactly and all
                others are shifted down (if necessary) to
                differ from that one by an integer number of
                bins.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class XAxisValidator(_plotly_utils.basevalidators.SubplotidValidator):

    def __init__(self, plotly_name='xaxis', parent_name='histogram', **kwargs):
        super(XAxisValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            dflt=kwargs.pop('dflt', 'x'),
            edit_type=kwargs.pop('edit_type', 'calc+clearAxisTypes'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class XValidator(_plotly_utils.basevalidators.DataArrayValidator):

    def __init__(self, plotly_name='x', parent_name='histogram', **kwargs):
        super(XValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc+clearAxisTypes'),
            role=kwargs.pop('role', 'data'),
            **kwargs
        )


import _plotly_utils.basevalidators


class VisibleValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='visible', parent_name='histogram', **kwargs
    ):
        super(VisibleValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            values=kwargs.pop('values', [True, False, 'legendonly']),
            **kwargs
        )


import _plotly_utils.basevalidators


class UnselectedValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='unselected', parent_name='histogram', **kwargs
    ):
        super(UnselectedValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Unselected'),
            data_docs=kwargs.pop(
                'data_docs', """
            marker
                plotly.graph_objs.histogram.unselected.Marker
                instance or dict with compatible properties
            textfont
                plotly.graph_objs.histogram.unselected.Textfont
                instance or dict with compatible properties
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class UirevisionValidator(_plotly_utils.basevalidators.AnyValidator):

    def __init__(
        self, plotly_name='uirevision', parent_name='histogram', **kwargs
    ):
        super(UirevisionValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class UidValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(self, plotly_name='uid', parent_name='histogram', **kwargs):
        super(UidValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            anim=kwargs.pop('anim', True),
            edit_type=kwargs.pop('edit_type', 'plot'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class TextsrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='textsrc', parent_name='histogram', **kwargs
    ):
        super(TextsrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class TextValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(self, plotly_name='text', parent_name='histogram', **kwargs):
        super(TextValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            array_ok=kwargs.pop('array_ok', True),
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class StreamValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='stream', parent_name='histogram', **kwargs
    ):
        super(StreamValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Stream'),
            data_docs=kwargs.pop(
                'data_docs', """
            maxpoints
                Sets the maximum number of points to keep on
                the plots from an incoming stream. If
                `maxpoints` is set to 50, only the newest 50
                points will be displayed on the plot.
            token
                The stream id number links a data trace on a
                plot with a stream. See
                https://plot.ly/settings for more details.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class ShowlegendValidator(_plotly_utils.basevalidators.BooleanValidator):

    def __init__(
        self, plotly_name='showlegend', parent_name='histogram', **kwargs
    ):
        super(ShowlegendValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'style'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class SelectedpointsValidator(_plotly_utils.basevalidators.AnyValidator):

    def __init__(
        self, plotly_name='selectedpoints', parent_name='histogram', **kwargs
    ):
        super(SelectedpointsValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class SelectedValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='selected', parent_name='histogram', **kwargs
    ):
        super(SelectedValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Selected'),
            data_docs=kwargs.pop(
                'data_docs', """
            marker
                plotly.graph_objs.histogram.selected.Marker
                instance or dict with compatible properties
            textfont
                plotly.graph_objs.histogram.selected.Textfont
                instance or dict with compatible properties
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class OrientationValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='orientation', parent_name='histogram', **kwargs
    ):
        super(OrientationValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc+clearAxisTypes'),
            role=kwargs.pop('role', 'info'),
            values=kwargs.pop('values', ['v', 'h']),
            **kwargs
        )


import _plotly_utils.basevalidators


class OpacityValidator(_plotly_utils.basevalidators.NumberValidator):

    def __init__(
        self, plotly_name='opacity', parent_name='histogram', **kwargs
    ):
        super(OpacityValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'style'),
            max=kwargs.pop('max', 1),
            min=kwargs.pop('min', 0),
            role=kwargs.pop('role', 'style'),
            **kwargs
        )


import _plotly_utils.basevalidators


class OffsetgroupValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='offsetgroup', parent_name='histogram', **kwargs
    ):
        super(OffsetgroupValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class NbinsyValidator(_plotly_utils.basevalidators.IntegerValidator):

    def __init__(
        self, plotly_name='nbinsy', parent_name='histogram', **kwargs
    ):
        super(NbinsyValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            min=kwargs.pop('min', 0),
            role=kwargs.pop('role', 'style'),
            **kwargs
        )


import _plotly_utils.basevalidators


class NbinsxValidator(_plotly_utils.basevalidators.IntegerValidator):

    def __init__(
        self, plotly_name='nbinsx', parent_name='histogram', **kwargs
    ):
        super(NbinsxValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            min=kwargs.pop('min', 0),
            role=kwargs.pop('role', 'style'),
            **kwargs
        )


import _plotly_utils.basevalidators


class NameValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(self, plotly_name='name', parent_name='histogram', **kwargs):
        super(NameValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'style'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class MetasrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='metasrc', parent_name='histogram', **kwargs
    ):
        super(MetasrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class MetaValidator(_plotly_utils.basevalidators.AnyValidator):

    def __init__(self, plotly_name='meta', parent_name='histogram', **kwargs):
        super(MetaValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            array_ok=kwargs.pop('array_ok', True),
            edit_type=kwargs.pop('edit_type', 'plot'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class MarkerValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='marker', parent_name='histogram', **kwargs
    ):
        super(MarkerValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Marker'),
            data_docs=kwargs.pop(
                'data_docs', """
            autocolorscale
                Determines whether the colorscale is a default
                palette (`autocolorscale: true`) or the palette
                determined by `marker.colorscale`. Has an
                effect only if in `marker.color`is set to a
                numerical array. In case `colorscale` is
                unspecified or `autocolorscale` is true, the
                default  palette will be chosen according to
                whether numbers in the `color` array are all
                positive, all negative or mixed.
            cauto
                Determines whether or not the color domain is
                computed with respect to the input data (here
                in `marker.color`) or the bounds set in
                `marker.cmin` and `marker.cmax`  Has an effect
                only if in `marker.color`is set to a numerical
                array. Defaults to `false` when `marker.cmin`
                and `marker.cmax` are set by the user.
            cmax
                Sets the upper bound of the color domain. Has
                an effect only if in `marker.color`is set to a
                numerical array. Value should have the same
                units as in `marker.color` and if set,
                `marker.cmin` must be set as well.
            cmid
                Sets the mid-point of the color domain by
                scaling `marker.cmin` and/or `marker.cmax` to
                be equidistant to this point. Has an effect
                only if in `marker.color`is set to a numerical
                array. Value should have the same units as in
                `marker.color`. Has no effect when
                `marker.cauto` is `false`.
            cmin
                Sets the lower bound of the color domain. Has
                an effect only if in `marker.color`is set to a
                numerical array. Value should have the same
                units as in `marker.color` and if set,
                `marker.cmax` must be set as well.
            color
                Sets themarkercolor. It accepts either a
                specific color or an array of numbers that are
                mapped to the colorscale relative to the max
                and min values of the array or relative to
                `marker.cmin` and `marker.cmax` if set.
            coloraxis
                Sets a reference to a shared color axis.
                References to these shared color axes are
                "coloraxis", "coloraxis2", "coloraxis3", etc.
                Settings for these shared color axes are set in
                the layout, under `layout.coloraxis`,
                `layout.coloraxis2`, etc. Note that multiple
                color scales can be linked to the same color
                axis.
            colorbar
                plotly.graph_objs.histogram.marker.ColorBar
                instance or dict with compatible properties
            colorscale
                Sets the colorscale. Has an effect only if in
                `marker.color`is set to a numerical array. The
                colorscale must be an array containing arrays
                mapping a normalized value to an rgb, rgba,
                hex, hsl, hsv, or named color string. At
                minimum, a mapping for the lowest (0) and
                highest (1) values are required. For example,
                `[[0, 'rgb(0,0,255)', [1, 'rgb(255,0,0)']]`. To
                control the bounds of the colorscale in color
                space, use`marker.cmin` and `marker.cmax`.
                Alternatively, `colorscale` may be a palette
                name string of the following list: Greys,YlGnBu
                ,Greens,YlOrRd,Bluered,RdBu,Reds,Blues,Picnic,R
                ainbow,Portland,Jet,Hot,Blackbody,Earth,Electri
                c,Viridis,Cividis.
            colorsrc
                Sets the source reference on plot.ly for  color
                .
            line
                plotly.graph_objs.histogram.marker.Line
                instance or dict with compatible properties
            opacity
                Sets the opacity of the bars.
            opacitysrc
                Sets the source reference on plot.ly for
                opacity .
            reversescale
                Reverses the color mapping if true. Has an
                effect only if in `marker.color`is set to a
                numerical array. If true, `marker.cmin` will
                correspond to the last color in the array and
                `marker.cmax` will correspond to the first
                color.
            showscale
                Determines whether or not a colorbar is
                displayed for this trace. Has an effect only if
                in `marker.color`is set to a numerical array.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class LegendgroupValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='legendgroup', parent_name='histogram', **kwargs
    ):
        super(LegendgroupValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'style'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class IdssrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='idssrc', parent_name='histogram', **kwargs
    ):
        super(IdssrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class IdsValidator(_plotly_utils.basevalidators.DataArrayValidator):

    def __init__(self, plotly_name='ids', parent_name='histogram', **kwargs):
        super(IdsValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            anim=kwargs.pop('anim', True),
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'data'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HovertextsrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='hovertextsrc', parent_name='histogram', **kwargs
    ):
        super(HovertextsrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HovertextValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='hovertext', parent_name='histogram', **kwargs
    ):
        super(HovertextValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            array_ok=kwargs.pop('array_ok', True),
            edit_type=kwargs.pop('edit_type', 'style'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HovertemplatesrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self,
        plotly_name='hovertemplatesrc',
        parent_name='histogram',
        **kwargs
    ):
        super(HovertemplatesrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HovertemplateValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='hovertemplate', parent_name='histogram', **kwargs
    ):
        super(HovertemplateValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            array_ok=kwargs.pop('array_ok', True),
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HoverlabelValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='hoverlabel', parent_name='histogram', **kwargs
    ):
        super(HoverlabelValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Hoverlabel'),
            data_docs=kwargs.pop(
                'data_docs', """
            align
                Sets the horizontal alignment of the text
                content within hover label box. Has an effect
                only if the hover label text spans more two or
                more lines
            alignsrc
                Sets the source reference on plot.ly for  align
                .
            bgcolor
                Sets the background color of the hover labels
                for this trace
            bgcolorsrc
                Sets the source reference on plot.ly for
                bgcolor .
            bordercolor
                Sets the border color of the hover labels for
                this trace.
            bordercolorsrc
                Sets the source reference on plot.ly for
                bordercolor .
            font
                Sets the font used in hover labels.
            namelength
                Sets the default length (in number of
                characters) of the trace name in the hover
                labels for all traces. -1 shows the whole name
                regardless of length. 0-3 shows the first 0-3
                characters, and an integer >3 will show the
                whole name if it is less than that many
                characters, but if it is longer, will truncate
                to `namelength - 3` characters and add an
                ellipsis.
            namelengthsrc
                Sets the source reference on plot.ly for
                namelength .
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class HoverinfosrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='hoverinfosrc', parent_name='histogram', **kwargs
    ):
        super(HoverinfosrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HoverinfoValidator(_plotly_utils.basevalidators.FlaglistValidator):

    def __init__(
        self, plotly_name='hoverinfo', parent_name='histogram', **kwargs
    ):
        super(HoverinfoValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            array_ok=kwargs.pop('array_ok', True),
            edit_type=kwargs.pop('edit_type', 'none'),
            extras=kwargs.pop('extras', ['all', 'none', 'skip']),
            flags=kwargs.pop('flags', ['x', 'y', 'z', 'text', 'name']),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class HistnormValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='histnorm', parent_name='histogram', **kwargs
    ):
        super(HistnormValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'style'),
            values=kwargs.pop(
                'values', [
                    '', 'percent', 'probability', 'density',
                    'probability density'
                ]
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class HistfuncValidator(_plotly_utils.basevalidators.EnumeratedValidator):

    def __init__(
        self, plotly_name='histfunc', parent_name='histogram', **kwargs
    ):
        super(HistfuncValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'style'),
            values=kwargs.pop('values', ['count', 'sum', 'avg', 'min', 'max']),
            **kwargs
        )


import _plotly_utils.basevalidators


class ErrorYValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='error_y', parent_name='histogram', **kwargs
    ):
        super(ErrorYValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'ErrorY'),
            data_docs=kwargs.pop(
                'data_docs', """
            array
                Sets the data corresponding the length of each
                error bar. Values are plotted relative to the
                underlying data.
            arrayminus
                Sets the data corresponding the length of each
                error bar in the bottom (left) direction for
                vertical (horizontal) bars Values are plotted
                relative to the underlying data.
            arrayminussrc
                Sets the source reference on plot.ly for
                arrayminus .
            arraysrc
                Sets the source reference on plot.ly for  array
                .
            color
                Sets the stoke color of the error bars.
            symmetric
                Determines whether or not the error bars have
                the same length in both direction (top/bottom
                for vertical bars, left/right for horizontal
                bars.
            thickness
                Sets the thickness (in px) of the error bars.
            traceref

            tracerefminus

            type
                Determines the rule used to generate the error
                bars. If *constant`, the bar lengths are of a
                constant value. Set this constant in `value`.
                If "percent", the bar lengths correspond to a
                percentage of underlying data. Set this
                percentage in `value`. If "sqrt", the bar
                lengths correspond to the sqaure of the
                underlying data. If "array", the bar lengths
                are set with data set `array`.
            value
                Sets the value of either the percentage (if
                `type` is set to "percent") or the constant (if
                `type` is set to "constant") corresponding to
                the lengths of the error bars.
            valueminus
                Sets the value of either the percentage (if
                `type` is set to "percent") or the constant (if
                `type` is set to "constant") corresponding to
                the lengths of the error bars in the bottom
                (left) direction for vertical (horizontal) bars
            visible
                Determines whether or not this set of error
                bars is visible.
            width
                Sets the width (in px) of the cross-bar at both
                ends of the error bars.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class ErrorXValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='error_x', parent_name='histogram', **kwargs
    ):
        super(ErrorXValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'ErrorX'),
            data_docs=kwargs.pop(
                'data_docs', """
            array
                Sets the data corresponding the length of each
                error bar. Values are plotted relative to the
                underlying data.
            arrayminus
                Sets the data corresponding the length of each
                error bar in the bottom (left) direction for
                vertical (horizontal) bars Values are plotted
                relative to the underlying data.
            arrayminussrc
                Sets the source reference on plot.ly for
                arrayminus .
            arraysrc
                Sets the source reference on plot.ly for  array
                .
            color
                Sets the stoke color of the error bars.
            copy_ystyle

            symmetric
                Determines whether or not the error bars have
                the same length in both direction (top/bottom
                for vertical bars, left/right for horizontal
                bars.
            thickness
                Sets the thickness (in px) of the error bars.
            traceref

            tracerefminus

            type
                Determines the rule used to generate the error
                bars. If *constant`, the bar lengths are of a
                constant value. Set this constant in `value`.
                If "percent", the bar lengths correspond to a
                percentage of underlying data. Set this
                percentage in `value`. If "sqrt", the bar
                lengths correspond to the sqaure of the
                underlying data. If "array", the bar lengths
                are set with data set `array`.
            value
                Sets the value of either the percentage (if
                `type` is set to "percent") or the constant (if
                `type` is set to "constant") corresponding to
                the lengths of the error bars.
            valueminus
                Sets the value of either the percentage (if
                `type` is set to "percent") or the constant (if
                `type` is set to "constant") corresponding to
                the lengths of the error bars in the bottom
                (left) direction for vertical (horizontal) bars
            visible
                Determines whether or not this set of error
                bars is visible.
            width
                Sets the width (in px) of the cross-bar at both
                ends of the error bars.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class CustomdatasrcValidator(_plotly_utils.basevalidators.SrcValidator):

    def __init__(
        self, plotly_name='customdatasrc', parent_name='histogram', **kwargs
    ):
        super(CustomdatasrcValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'none'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class CustomdataValidator(_plotly_utils.basevalidators.DataArrayValidator):

    def __init__(
        self, plotly_name='customdata', parent_name='histogram', **kwargs
    ):
        super(CustomdataValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'data'),
            **kwargs
        )


import _plotly_utils.basevalidators


class CumulativeValidator(_plotly_utils.basevalidators.CompoundValidator):

    def __init__(
        self, plotly_name='cumulative', parent_name='histogram', **kwargs
    ):
        super(CumulativeValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            data_class_str=kwargs.pop('data_class_str', 'Cumulative'),
            data_docs=kwargs.pop(
                'data_docs', """
            currentbin
                Only applies if cumulative is enabled. Sets
                whether the current bin is included, excluded,
                or has half of its value included in the
                current cumulative value. "include" is the
                default for compatibility with various other
                tools, however it introduces a half-bin bias to
                the results. "exclude" makes the opposite half-
                bin bias, and "half" removes it.
            direction
                Only applies if cumulative is enabled. If
                "increasing" (default) we sum all prior bins,
                so the result increases from left to right. If
                "decreasing" we sum later bins so the result
                decreases from left to right.
            enabled
                If true, display the cumulative distribution by
                summing the binned values. Use the `direction`
                and `centralbin` attributes to tune the
                accumulation method. Note: in this mode, the
                "density" `histnorm` settings behave the same
                as their equivalents without "density": "" and
                "density" both rise to the number of data
                points, and "probability" and *probability
                density* both rise to the number of sample
                points.
"""
            ),
            **kwargs
        )


import _plotly_utils.basevalidators


class BingroupValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='bingroup', parent_name='histogram', **kwargs
    ):
        super(BingroupValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )


import _plotly_utils.basevalidators


class AutobinyValidator(_plotly_utils.basevalidators.BooleanValidator):

    def __init__(
        self, plotly_name='autobiny', parent_name='histogram', **kwargs
    ):
        super(AutobinyValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'style'),
            **kwargs
        )


import _plotly_utils.basevalidators


class AutobinxValidator(_plotly_utils.basevalidators.BooleanValidator):

    def __init__(
        self, plotly_name='autobinx', parent_name='histogram', **kwargs
    ):
        super(AutobinxValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'style'),
            **kwargs
        )


import _plotly_utils.basevalidators


class AlignmentgroupValidator(_plotly_utils.basevalidators.StringValidator):

    def __init__(
        self, plotly_name='alignmentgroup', parent_name='histogram', **kwargs
    ):
        super(AlignmentgroupValidator, self).__init__(
            plotly_name=plotly_name,
            parent_name=parent_name,
            edit_type=kwargs.pop('edit_type', 'calc'),
            role=kwargs.pop('role', 'info'),
            **kwargs
        )
