# This file is automatically generated from xbus/control.proto, DO NOT EDIT!

import asyncio
import nats.aio

import nrpc
import nrpc.exc
from nrpc import nrpc_pb2

import xbus.xbus_pb2 as xbus_dot_xbus__pb2
import xbus.control_pb2 as xbus_dot_control__pb2
import nrpc.nrpc_pb2 as nrpc_dot_nrpc__pb2


PKG_SUBJECT = 'xbus.default.control'
PKG_SUBJECT_PARAMS = []
PKG_SUBJECT_PARAMS_COUNT = 0


Account_SUBJECT = 'account'
Account_SUBJECT_PARAMS = []
Account_SUBJECT_PARAMS_COUNT = 0


class AccountHandler:
    methods = {
        'list': ('List', 0, xbus_dot_control__pb2.AccountListRequest, True, False, False),
        'update': ('Update', 0, xbus_dot_control__pb2.AccountUpdateRequest, True, False, False),
        'delete': ('Delete', 0, xbus_dot_control__pb2.AccountIDRequest, True, True, False),
        'renew_apikey': ('RenewAPIKey', 0, xbus_dot_control__pb2.AccountIDRequest, True, False, False),
        'get_apikey': ('GetAPIKey', 0, xbus_dot_control__pb2.AccountIDRequest, True, False, False),
        'set_apikey': ('SetAPIKey', 0, xbus_dot_control__pb2.AccountUpdateRequest, True, False, False),
        'resetcert': ('ResetCert', 0, xbus_dot_control__pb2.AccountIDRequest, True, True, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Account_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Account_SUBJECT, Account_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Account.%s handler:" % mname, e)


class AccountClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def List(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'list'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.AccountListReply.FromString(rawRep.data)

    async def Update(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'update'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Account.FromString(rawRep.data)

    async def Delete(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'delete'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None

    async def RenewAPIKey(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'renew_apikey'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Account.FromString(rawRep.data)

    async def GetAPIKey(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'get_apikey'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Account.FromString(rawRep.data)

    async def SetAPIKey(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'set_apikey'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Account.FromString(rawRep.data)

    async def ResetCert(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Account_SUBJECT + '.' + 'resetcert'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None


Actor_SUBJECT = 'actor'
Actor_SUBJECT_PARAMS = []
Actor_SUBJECT_PARAMS_COUNT = 0


class ActorHandler:
    methods = {
        'create': ('Create', 0, xbus_dot_control__pb2.ActorRequest, True, False, False),
        'update': ('Update', 0, xbus_dot_control__pb2.ActorRequest, True, False, False),
        'delete': ('Delete', 0, xbus_dot_control__pb2.ActorRequest, True, False, False),
        'query': ('Query', 0, xbus_dot_control__pb2.ActorRequest, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Actor_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Actor_SUBJECT, Actor_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Actor.%s handler:" % mname, e)


class ActorClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Create(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Actor_SUBJECT + '.' + 'create'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.ActorReply.FromString(rawRep.data)

    async def Update(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Actor_SUBJECT + '.' + 'update'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.ActorReply.FromString(rawRep.data)

    async def Delete(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Actor_SUBJECT + '.' + 'delete'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.ActorReply.FromString(rawRep.data)

    async def Query(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Actor_SUBJECT + '.' + 'query'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.ActorReply.FromString(rawRep.data)


Envelope_SUBJECT = 'envelope'
Envelope_SUBJECT_PARAMS = []
Envelope_SUBJECT_PARAMS_COUNT = 0


class EnvelopeHandler:
    methods = {
        'purge': ('Purge', 0, None, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Envelope_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Envelope_SUBJECT, Envelope_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Envelope.%s handler:" % mname, e)


class EnvelopeClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Purge(
        self,
    ):
        subject = PKG_SUBJECT + '.' + Envelope_SUBJECT + '.' + 'purge'
        rawReq = b''

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.TaskProgress.FromString(rawRep.data)


Pipeline_SUBJECT = 'pipeline'
Pipeline_SUBJECT_PARAMS = []
Pipeline_SUBJECT_PARAMS_COUNT = 0


class PipelineHandler:
    methods = {
        'query': ('Query', 0, xbus_dot_control__pb2.PipelineQueryRequest, True, False, False),
        'save': ('Save', 0, xbus_dot_control__pb2.PipelineSaveRequest, True, False, False),
        'setstatus': ('SetStatus', 0, xbus_dot_xbus__pb2.PipelineInfo, True, False, False),
        'getgraph': ('GetGraph', 0, xbus_dot_xbus__pb2.PipelineInfo, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Pipeline_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Pipeline_SUBJECT, Pipeline_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Pipeline.%s handler:" % mname, e)


class PipelineClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Query(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Pipeline_SUBJECT + '.' + 'query'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.PipelineQueryReply.FromString(rawRep.data)

    async def Save(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Pipeline_SUBJECT + '.' + 'save'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.PipelineSaveReply.FromString(rawRep.data)

    async def SetStatus(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Pipeline_SUBJECT + '.' + 'setstatus'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.PipelineSetStatusReply.FromString(rawRep.data)

    async def GetGraph(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Pipeline_SUBJECT + '.' + 'getgraph'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.StringReply.FromString(rawRep.data)


Logs_SUBJECT = 'logs'
Logs_SUBJECT_PARAMS = []
Logs_SUBJECT_PARAMS_COUNT = 0


class LogsHandler:
    methods = {
        'purge': ('Purge', 0, xbus_dot_control__pb2.LogsPurgeRequest, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Logs_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Logs_SUBJECT, Logs_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Logs.%s handler:" % mname, e)


class LogsClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Purge(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Logs_SUBJECT + '.' + 'purge'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.LogsPurgeReply.FromString(rawRep.data)


PMProcess_SUBJECT = 'pm'
PMProcess_SUBJECT_PARAMS = []
PMProcess_SUBJECT_PARAMS_COUNT = 0


class PMProcessHandler:
    methods = {
        'query': ('Query', 0, xbus_dot_control__pb2.PMProcessQueryRequest, True, False, True),
        'setstatus': ('SetStatus', 0, xbus_dot_control__pb2.PMProcessSetStatusRequest, True, True, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", PMProcess_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                PMProcess_SUBJECT, PMProcess_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in PMProcess.%s handler:" % mname, e)


class PMProcessClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Query(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + PMProcess_SUBJECT + '.' + 'query'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.PMProcessQueryReply.FromString(rawRep.data)

    async def SetStatus(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + PMProcess_SUBJECT + '.' + 'setstatus'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None


Process_SUBJECT = 'process'
Process_SUBJECT_PARAMS = []
Process_SUBJECT_PARAMS_COUNT = 0


class ProcessHandler:
    methods = {
        'query': ('Query', 0, xbus_dot_control__pb2.ProcessQueryRequest, True, False, True),
        'control': ('Control', 0, xbus_dot_control__pb2.ProcessControlRequest, True, True, False),
        'export': ('Export', 0, xbus_dot_control__pb2.ProcessExportRequest, True, False, False),
        'exportstream': ('ExportStream', 0, xbus_dot_control__pb2.ProcessExportRequest, True, False, True),
        'purge': ('Purge', 0, xbus_dot_control__pb2.ProcessPurgeRequest, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default.control", Process_SUBJECT, method
        ])

    @asyncio.coroutine
    def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Process_SUBJECT, Process_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                yield from nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = yield from method(*mt_params)
            except nrpc.ClientError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                yield from self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Process.%s handler:" % mname, e)


class ProcessClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Query(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Process_SUBJECT + '.' + 'query'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.ProcessQueryReply.FromString(rawRep.data)

    async def Control(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Process_SUBJECT + '.' + 'control'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None

    async def Export(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Process_SUBJECT + '.' + 'export'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_control__pb2.ProcessExportReply.FromString(rawRep.data)

    async def ExportStream(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Process_SUBJECT + '.' + 'exportstream'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.OctetStreamList.FromString(rawRep.data)

    async def Purge(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Process_SUBJECT + '.' + 'purge'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_control__pb2.TaskProgress.FromString(rawRep.data)
