# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing import Any, Optional

from ethos.ethos_client.models.list_resource import ListResource
from ethos.ethos_client.models.resource import Resource
from ethos.ethos_client.models.resource_create import ResourceCreate

from ethos.ethos_client.api_client import ApiClient
from ethos.ethos_client.api_response import ApiResponse
from ethos.ethos_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ResourcesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_resource(self, resource_create : ResourceCreate, expand : Optional[Any] = None, **kwargs) -> Resource:  # noqa: E501
        """Create Resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_resource(resource_create, expand, async_req=True)
        >>> result = thread.get()

        :param resource_create: (required)
        :type resource_create: ResourceCreate
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Resource
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_resource_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_resource_with_http_info(resource_create, expand, **kwargs)  # noqa: E501

    @validate_arguments
    def create_resource_with_http_info(self, resource_create : ResourceCreate, expand : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_resource_with_http_info(resource_create, expand, async_req=True)
        >>> result = thread.get()

        :param resource_create: (required)
        :type resource_create: ResourceCreate
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Resource, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'resource_create',
            'expand'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_resource" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['resource_create'] is not None:
            _body_params = _params['resource_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['OAuth2PasswordBearer', 'APIKeyCookie']  # noqa: E501

        _response_types_map = {
            '201': "Resource",
            '422': "HTTPValidationError",
        }

        return self.api_client.call_api(
            '/v1/resources', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_resources(self, related : Any, type : Optional[Any] = None, name : Optional[Any] = None, version_tag : Optional[Any] = None, tag : Optional[Any] = None, expand : Optional[Any] = None, **kwargs) -> ListResource:  # noqa: E501
        """Get Resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resources(related, type, name, version_tag, tag, expand, async_req=True)
        >>> result = thread.get()

        :param related: (required)
        :type related: object
        :param type:
        :type type: object
        :param name:
        :type name: object
        :param version_tag:
        :type version_tag: object
        :param tag:
        :type tag: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListResource
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_resources_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_resources_with_http_info(related, type, name, version_tag, tag, expand, **kwargs)  # noqa: E501

    @validate_arguments
    def get_resources_with_http_info(self, related : Any, type : Optional[Any] = None, name : Optional[Any] = None, version_tag : Optional[Any] = None, tag : Optional[Any] = None, expand : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Resources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resources_with_http_info(related, type, name, version_tag, tag, expand, async_req=True)
        >>> result = thread.get()

        :param related: (required)
        :type related: object
        :param type:
        :type type: object
        :param name:
        :type name: object
        :param version_tag:
        :type version_tag: object
        :param tag:
        :type tag: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListResource, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'related',
            'type',
            'name',
            'version_tag',
            'tag',
            'expand'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resources" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('related') is not None:  # noqa: E501
            _query_params.append(('related', _params['related']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('version_tag') is not None:  # noqa: E501
            _query_params.append(('version_tag', _params['version_tag']))

        if _params.get('tag') is not None:  # noqa: E501
            _query_params.append(('tag', _params['tag']))

        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2PasswordBearer', 'APIKeyCookie']  # noqa: E501

        _response_types_map = {
            '200': "ListResource",
            '422': "HTTPValidationError",
        }

        return self.api_client.call_api(
            '/v1/resources', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
