# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, validator

class ModelVersion(BaseModel):
    """
    ModelVersion
    """
    object: Optional[Any] = Field(...)
    id: Optional[Any] = Field(...)
    model: Optional[Any] = Field(...)
    version_number: Optional[Any] = Field(...)
    state: Optional[Any] = Field(...)
    full_name: Optional[Any] = Field(...)
    created_at: Optional[Any] = Field(...)
    finalized_at: Optional[Any] = Field(...)
    reports: Optional[Any] = Field(...)
    __properties = ["object", "id", "model", "version_number", "state", "full_name", "created_at", "finalized_at", "reports"]

    @validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('draft', 'processing', 'processed', 'error'):
            raise ValueError("must be one of enum values ('draft', 'processing', 'processed', 'error')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModelVersion:
        """Create an instance of ModelVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if object (nullable) is None
        # and __fields_set__ contains the field
        if self.object is None and "object" in self.__fields_set__:
            _dict['object'] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if model (nullable) is None
        # and __fields_set__ contains the field
        if self.model is None and "model" in self.__fields_set__:
            _dict['model'] = None

        # set to None if version_number (nullable) is None
        # and __fields_set__ contains the field
        if self.version_number is None and "version_number" in self.__fields_set__:
            _dict['version_number'] = None

        # set to None if state (nullable) is None
        # and __fields_set__ contains the field
        if self.state is None and "state" in self.__fields_set__:
            _dict['state'] = None

        # set to None if full_name (nullable) is None
        # and __fields_set__ contains the field
        if self.full_name is None and "full_name" in self.__fields_set__:
            _dict['full_name'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if finalized_at (nullable) is None
        # and __fields_set__ contains the field
        if self.finalized_at is None and "finalized_at" in self.__fields_set__:
            _dict['finalized_at'] = None

        # set to None if reports (nullable) is None
        # and __fields_set__ contains the field
        if self.reports is None and "reports" in self.__fields_set__:
            _dict['reports'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModelVersion:
        """Create an instance of ModelVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModelVersion.parse_obj(obj)

        _obj = ModelVersion.parse_obj({
            "object": obj.get("object"),
            "id": obj.get("id"),
            "model": obj.get("model"),
            "version_number": obj.get("version_number"),
            "state": obj.get("state"),
            "full_name": obj.get("full_name"),
            "created_at": obj.get("created_at"),
            "finalized_at": obj.get("finalized_at"),
            "reports": obj.get("reports")
        })
        return _obj


