# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field
from ethos.ethos_client.models.list_relationship import ListRelationship

class User(BaseModel):
    """
    User
    """
    object: Optional[Any] = Field(...)
    id: Optional[Any] = Field(...)
    email: Optional[Any] = Field(...)
    is_active: Optional[Any] = Field(...)
    is_superuser: Optional[Any] = Field(...)
    is_verified: Optional[Any] = Field(...)
    name: Optional[Any] = Field(...)
    teams: Optional[ListRelationship] = Field(...)
    __properties = ["object", "id", "email", "is_active", "is_superuser", "is_verified", "name", "teams"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> User:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of teams
        if self.teams:
            _dict['teams'] = self.teams.to_dict()
        # set to None if object (nullable) is None
        # and __fields_set__ contains the field
        if self.object is None and "object" in self.__fields_set__:
            _dict['object'] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if is_active (nullable) is None
        # and __fields_set__ contains the field
        if self.is_active is None and "is_active" in self.__fields_set__:
            _dict['is_active'] = None

        # set to None if is_superuser (nullable) is None
        # and __fields_set__ contains the field
        if self.is_superuser is None and "is_superuser" in self.__fields_set__:
            _dict['is_superuser'] = None

        # set to None if is_verified (nullable) is None
        # and __fields_set__ contains the field
        if self.is_verified is None and "is_verified" in self.__fields_set__:
            _dict['is_verified'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if teams (nullable) is None
        # and __fields_set__ contains the field
        if self.teams is None and "teams" in self.__fields_set__:
            _dict['teams'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> User:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return User.parse_obj(obj)

        _obj = User.parse_obj({
            "object": obj.get("object"),
            "id": obj.get("id"),
            "email": obj.get("email"),
            "is_active": obj.get("is_active"),
            "is_superuser": obj.get("is_superuser"),
            "is_verified": obj.get("is_verified"),
            "name": obj.get("name"),
            "teams": ListRelationship.from_dict(obj.get("teams")) if obj.get("teams") is not None else None
        })
        return _obj


