#!/usr/bin/env python
# -*- coding: ascii -*-
"""Holds base64 version of Sphinx logo.  Can save as png file"""
from __future__ import absolute_import
from __future__ import print_function

import base64


#  pylint: disable=C0326, C0103

def save_logo_to_file( fullpath, in_test_mode=False ):
    """Saves base64 version of Sphinx logo as png file"""
    decoded_str = base64.b64decode( logo_b64str.replace('\n','') )

    if in_test_mode:
        print( "TESTING make file:", fullpath )
    else:
        print( "Saving LOGO:", fullpath )
        fOut = open(fullpath,'wb')
        fOut.write( decoded_str )
        fOut.close()



logo_b64str="""
iVBORw0KGgoAAAANSUhEUgAAAMoAAAA9CAIAAABjkGFeAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH2AMZEgkN6NnmzQAAIABJREFUeNrtnXmcHGWZ+N+3zq6u
vq+Z7p6z557MkWRyg4RAEoiAgBxZQBRRQVkUVkUFF9dlvQDx3HUFV0BEUTQiiNwKIRAIIeckk8nc
0zPT991d3XW+7/5RpJnMlQTY/cH+5vmjP1VdVW9Vve+3n+d5n/d534YYY7Aoi/I/I8RiFSzKIl6L
8oEU6n/zZrohLn9O34UQQgj1jem7i7KI10IwAQAQQgghVVUVRZFlWTkmqqqqqgoAIAgCY0ySJEVR
FEWxLMuyLMMwNE0TBEEQxHTyFuUDJPA9d+3xMVFVVZblYrFYKBRyuXyxVIQAMAzDcRxFUTRN6wBJ
soKRxrIshFCSJJ05URRVVYMQGHneYjabTCaGYSiKIghikbP/7/AqmzmEkKIopVIpm81mMplUKgUA
MFssOiKpTG4qkpgIJ+LJbK4gpjKFeDqPMSBJiBHiDbTDarKYOY/DXFftrfK5PS6HJEmFQqFYLLIs
63Q6LRaLwWDQtdqiAf0/jleZKl1RFQqFTDabTCRyuRzLGqw2q9vlisbTB4+MHhocHwrG03mlKGNJ
wQqCGsIaAggD/f4QAgICEgKSACwFjAw0GaCVp5prK7rb6ztaA2YTn8lkSqUSJAiX02mz2YxGI8Mw
i6bz/xpeZfOnKIooivl8Pp1OxxMJRZZNJpPdbudNpoHhif19o7t7RyfiQkHEJQWoCGgIIgABgDoM
uvLRqTjO3ccYQEwATJGYo4HZAO080VjlWN7R0NkWqHA7M5lMsVhEGDvsdpvNxvO8bjqn67PyxowX
XKTw/YIXxlhvjOl9PYSQLMu6+Usmk6lUmiQJq9XqdLpESe7tH917eGR//2QyrxYkIKpQRRADAkJI
EARFQpqEDAVpEtAkZCjAkJggAMBA12QaArKKJRVIKlJUrGpYQxhgRELE0cBkAHYjUe0x9XQEutob
a6u9+XxeEARFUXiet1gsPM9zHEfTtH47CKH+wJqmybIMANAV3sKEYYx3HhjfvmdkMppVVOSyGdsC
FRtXN/rclkVc3hu8yhghhMp+uiRJZV1VKAhGI2ez2RwOx8RUdH/fyJu9IwMTyVwRF2UgIwJhCCBJ
EARDEQYGGhnIM5A3AJ/L3FDtrnBZbVbeZjHZzLzJZMQYK4oqK6qiqEJJCkVTwXByLJQcD2WyRTUv
4pKEFA0hpBEAsxQ2scDKwQo7u6y9vrs90NJYr2mqIAiSJCmKgjGmaZqmaYqiMMaiKIqiSBCEwWDw
eDx+v1/Xc3NWx9BE8kv3/OXgYGRmNUGwrrvua9ee2dFQuQjNu8VLVdVQKDQwMOB0OnXFpWkIQEBT
lKppxZKcSOeHxiMDo5GB8Wgyp5QUIGsEAgQkSIokWJo0sqSZg16HsanGHah2VVU6eY5maVLVVKEg
FIuCJEmSJKuqommIJN+O7lIUxfO80Wg0Go2swSArKFOQg6Hk0GR8aDweihcESZNkTdUQATSaxDwD
LBxRXWnzV9h9FfZKt8NuNVEkSZKQIkkAgCQrxZJYKhU721szmXRLS4vdbp8Trxd2Dd581xOiol21
ZemmNU0eh6lQlA8Ohf/4fO/h4SgAYHmbf9v3r16E5t3GvTRNSyaTY2PjgUDDk8/8XVY1WdESqdzo
RDSeEQoiLoi4JAMFQwwpgqAoijQwlImjrEbSYSKXNFR2tta2N9VazHwkEo3FohOj/YqiUhRpsVit
VqvH47FarRzH0TRTEsViSWRoijMYaJqSJCmTyWQymUQimc1lNVUlSara6VjW0ump8Miy2jcYPHg0
uK9vPJou5YtqpqTGc/JgOATxJE0glsI0gUkCkxCTECOkiaIkyorNxF5x0VkXnLshFAqZTCbdgE5/
5Uy+dPPdfxFE5avXnPnZy9aUv1/e5v/4+T1fvufJx148zLH0IjHvTVhVURQIiWQ6e+9vnxUkhACh
IkJFUMMEhhQgSJKkaJrmWNpspOw85XVyy5fUdbbUNTXUiCUxEgkf6j2QyWRJinQ5nS0tLW6Px2g0
xuLpyWh695HoZGwglROzgqJoAAFAAkASiKWA00zXee01PmdNTV2Px5nP5WKxWCKRGB0dGR4eZg2s
0+G4eGPPpy7fFIrG+wYnevvHewcmUzlREBVRVvKiqioy0jSEFKypSFM1VcFIE0ryy6/tu/C8jdlk
UhAEm802432ff31QKMkAgDN66mccIiD89ufPfXnv6PJW38xaUrWiqEiyKkqqKCuirCqKZjUbKhxm
M8/OV7eFknzgaCgYyRgYak1njXd+r254Itk/Fs/kS7Ve+5rOGoo6bhBPktV9R0OjkylRUbubvMvb
/DMuRwj3DkWC4fSKJVVe1wl8x6Ko7Ng7mhPE1Z01NZVv1084njs4GNEQaql1N1Q7Z1+YzpV2HQoi
hDsaK6dfODde5V4hRVHZvBBNl4oyhgRFkBRB0hRFsgxl5Bgrz9hNTK3X2tPZ0N0WqKnyxuLx0NTU
8889J4qS3W6rqKxsX7LE6XBMRZNHR6NP7nxjOJQvKqSo0TKiZERqwKxhAmNdi2AIMAk1OqPtmxIM
ZMZI9dsMWkeDp6O5qmfFCkWWE4lEOp3WI2oDAwM8b2ypda1Z2syb+NHx0NBYKDgVHQ5GJkLxoigr
iqqpqqqpSFNJgHmO4gzU8PBIld+XSCTMZjNFHffuR0Zi+kY2L86uE46lf3/nVRVO84zvv3v/iw88
/uacrdUe8HzsvOWXbeyawQQA4Ae/frl81WWbOu+6+bw5S8gJ4nmff0BSVH33b/d+JlB1XOu+sm/s
03f8Ud+urrC+fP/nZpSwt3/qslseBgDU+ex/uPtjLhu/AF4PPbnnzgdeAgB87rI1X7nmzDI6533h
gXSupO/+5CsfuWB9+4wLL/7iQ+PhNACgu9n75x9+4sTaSx/DoWi6IJQgQdI0pGnawLI8x1h41m5m
m+s8PV3NnW0Nbqd9cnJyYmJs966dNE37/P7u7u7KyspCURoYDf91R//hkWSyRJRURkI0BjaCwBSB
MUEo2KACCkM9ToEBBgAgDDSGFDEAeYXOyDhcRKOZwosHD9rYN9vrnJ0t1W0trRCCVCqVyWRkWc7l
cqlUSlVVo5FvC1Ss6AyYzRaKohLJlCjJiqLIiiLLKmdgbFaLy2kXRbFQKOjWnyTJ6fax3Ir3/WnX
mq6a2c7ZnD/c8z7UVgalpdbd0VihaXh4Mtk7FOkbid3202cefe7AA/96uc3MTb/qqi3LylctYHAt
vOH89W3bXujVd1lmZmOdtaqh0mWOJPJzHgUA9LT5G6tdQxOJsVD6mm88+sj3rjQb59Wpl5zd+f1f
bdcQnl6U3cL97ntXXXjzg6KsAgB+/Mir532ojSDgjJrR8fro2R0nZRx1vBiGVhSl3mclScpkZAM1
FW2NtU2B6kBtFU2TY2NjB/fvjcXibre7qsrfsWQJz5uGxsNvHA4demLfRFIRVEZCtAZ4goAsia2s
wlPFarehqdopYfaPu0sIGQA4Fp0CGGDEELLPULpgXXWmoAxOpsciYlEh0pIhKbLBg8Udfb1Wdk9L
ta2rpbq1scbEc+l0OpfLlUolkiREUSwWi1NTU6qq0jQNoT5YCQw0ocqlSDgfjYQsFovT6fR4PDNU
FwCg+phWf+nNkW/94m9f//TZMypxTmmpc5e3z1/fduPWdfr2m32TN3znsXha2H80/LWfPP3zr390
+lWBKgdLk5KiLYwXAKC93rPt2LZhFkAQwpY6t46XYa5yIIStde6hiQQA4PBw9DN3bPvVHZfPCSIA
wG3nK5zmUDw340bNta4bLl/7g4d36Mb6yR1HPjJNgcmK1jcc1V9q6+buk8VLURQDy9bV19z19ets
VovNZpElORIJRyKR554/rMhydXVNa1vb2WefnUhl+4Ym/75n15HxVE6iihqjYApAnqEAR2MLU/La
ya7Gitb6ylq/GwKEENpxKAEpTGAWgLL2wgBjCAmKIqrd/Kolji2nkSzDjoeTvYOR3X3hiSTOymyy
RAezpZ39hyzM/roKY1dLdVtTTaChQSgUBEHQY/qUqkIIKYoiSVKPeKmqCiF0OByBQMBms5XHLqfL
ueta7n5wO8IYAHD/428OBpPf/cK5fo91YbxMHGMzGzJ5cUbzr2iv+sXtl1z0xYcAAM/uHBgMJppq
XNNb3WIyxNPCCfGymgzl7TmxsBzz8AzzQGO3vK04d/UGP3/n4/9528XTu+rTpdJpDsVzs2/0mUtW
P/r8wcloFgBw5wMvbV7TVKb5gcd3R5J5CMF3P79l9oVzP5Me5Uqn07IsFQqF3lw+l8txRq7C4/F4
PB0dHazBcHR48pW9Iwce2RHOKIJMiYhGgCVI0kBDB6taObmlytLZ5G1r8DntllQ6XcjnB472B4Pj
S5ctD8ZLmOQIwMC3tJcet0UAEDIwRhMZ3kCGw2GCIFmDYVWb+4L1S+Kp/N4jky/vC47H1ZTIxARq
PCPtHu63MIecJqKxxl1f7amvrqyv83GcQZIkWZZlWYaQYBiaZVmaprPZbDqdni8qUeezbz2n+5Fn
9uu7O/aNnnPDL7/2yQ1XfXjpwmFY3sDoeFHHt1l3i29tV81rB4MAgFf3j03HCwBAHuPbsCBe029t
YOY48+1y5sGLJCAAwGigi6Ki92Bu/enTd9704TlfiiQhAICmyBnfGxjqG9dtvO7ftgEAQvHcvdt2
3XTl6QCAI6MxXatdf8maVR3VJ9VzxBiXSqV8Pm82my1Wq9frNfK8zWoVJTk4GRmeiD758uH+sURO
JIoKIWMKQpqmCI7FFoPqseKupsqORl9zwI+RlslkcpmUkM84nU53fT1CSFUViqIQJgiKJQEDyi+J
McaYAAQgaA1hi8Xi9Xo5jsvn84lE4tChQwRBdAbsm09rG52Ib98z/FpvKFkgkkUylgejSfVgcIqj
gkYGGWlkoKHNwtktvNVklBU5k81nc3kDBW656TPRaLSystJimbsPdft1Zx8Zje0/GtJ3hZJ8+8+e
fXLHke99YUudzz4fASw7b++7p71KxyuWKsysZICP6STyhKO6OiWzuwjHfpcneAxdN/cORQaDCQDA
H57vtVuMt167Yb7SGHqOR9q0punMnsBLe0YAAD//w+uXnN3ptBlvuutxWdFWtld96eNnnEJgQlGU
kiiuWrXqjb2HJsPDyUxhMpKOpoSCDEUFShqJIUVSBMdANwesnNZca2tv8LU2+Kq97lwul8/nJ4JB
k4l3OBz19Vaj0UjTNEmSpVLJarNlMtl6r5kZAxiyABLHahEDjGiscaTidVdomma3200mk9Pp9Pv9
+hhUNBo9ePCgwWC45KwlHzt/5esHhv++a7A/mM2WQE6CKQEApEGsElglQA5iDWINaYqiKBipXofh
1V17u5e0JBIJnudn+166nfrtd6/42o+femL7kekG5cM33v+vn9t02aauOeuKmDXK+bZi45i3bOj8
QYrZquI4L+UYPvOfdgxTeiG8CALed/sll37518lsEQBw37Zddgv32UvXzHm7+e71jes3vnrDLxVV
E2X13+57oc7vGAwmHRbuJ1+9kJrH2lLzjQghhAGEv3tyZ/9YQsWEikkASYZhOJa284TFSNT7rZ3N
1S0N/oZav6aquVy2WCyOjo7a7fbq6mqTyaRnzsBjAgCgadpusw0ODq/qqPvr/qmYakGQeat6MIJY
MWPRb1Ya6vz5fE4fHNTTCVmWtVgsFRUVhUIhmUyGQuF8IV/rdvzzZ7dEE9ntb/S/9OZIOKVlBEJS
gKZirCGkqVhTkaYgTQZIJSH++47d609bFQqFKioqeJ6f0zpwLP2jWz6ytNl356+2S/JbfcmSpHzl
R08NBpO3XrthATs5+9BUNKtvrFpSPZ/WWRivt7XXPO2Hj7dr8wlJEnU++4N3XH7Frb8tFGXdhbJb
uJnOOAazrXxZ6v2OT1+88j//8DoA4LnXB0kCQgh++OULKl3mUwur6mPXBCQSWTGRkwGkSApaTHSl
ja52G89dv2ztik6b1VwqlQ729r62c8zlcvl8Pq/XazabWZYlSXLOvD+SJCsqKkbHxrKp2FWnmR98
NVOATgQYDACBNQ7lvDB08YYl2WzG5XKVA+v6J0mSBoOBZVmbzebz+RKJxMjIyLPPPOP2VHz84jO2
nrf2F488/9Tro3GV0ACBAQEAASAgCMhStJGmnBaaImEsnjAYDNls1mg0zudRQQg/edHKM1YEvvSD
Jw8cDZe//8WfdtnNhs9dvnZevMBxBcZShSe29+lufs+sgOf0cO5EJDPf0b6R6MJ4vd2QxEIn6MR0
NFbed/sl13zjUVnRAAC3/fQZm5k7Z23zDJoX6DLfuHXdY38/HEnmAQAawv+4dd0ZPYFTi9q/lRYD
AUkSNhPjMLOSRiBAqhpMCUgD8u+e2bvjzYFAtbvW7/JXuPz+KiNngBAWBEGWZYvFoltDPcV5OmQk
STocjqXd3b29h5wWy20XuPaPZcMZVCjJDiOuseOuQAfSZJPJ5Ha7y5276UnVsiwLgpBMJnO5nMVi
Wb16TSpX+t1fXnnjUHAkLORFiDCEBKQhpGmSZw1VbuPqroZlSwJet43jWEkUkUbMztKZLQ1Vzm3f
v/rpV47+++93Hh2L61/e8+uXl7b41nbXHjeAht4qaiAY7x0MkwQRSxf29E09+tyBfFG64Iy2f7l+
4xwoH7v/YDCeyAjzPYZuywAA9Hx44fJYLbnAcebY0bVdtY/eddUX7noiGM4ghG/87p+/dPUZ112y
WkdKN47U/CgbOWbrOd0//u0r+m4qWyyn1ZwsXhBCkiSNHJfJZO678+ZwLDkwMnV0JHR4ODwWzmdL
OFlEo8nS7tEQb4haOcJmBJV2dkmjv72lrrbKG4/HZVmmKErP+CsrM91EUhTl9/uNRuPo6OjkaH+D
1drt5Y28WSyJsiwJhWx9fb3D4dCTHcrpNIqiCIKQSqUSiSTDMA6H3WiyvPrmkZfeHJlMa2kBC6Km
KBBpkCKhjSOdPLm6o2rzh5a1NNVGI5FkMqmpMmew+rxe3WoTxImnSJEEcf4Zbeee1nLj9/787M4B
naR7t+2aiZeG9I2H/7rv4b/uK39/+rK6n115cU971cJ3uenK0y8+q2O+o488s/+2nz6zcJNP10/z
mtdpAHQ3+x675+OXf+Xh4cmUqqE7H3wpGMl8+8ZzIIT6T2UB7XVoKPIfv985/fFWLqla4Pnnxsvh
cHR1dUWj0aGhIYqivQ5zS92yT16+UZLUg0fH9/dP7u0PJfIoLxFZmQ4L5FiW6ItG7HtDlVaiu6Wq
o6XOV2nLZrOJREJVVYZleaPRYDDoMzV0MxcIBJxOZy6XKxQK6ZTIcZye60zTdD6fL1Olp+qLokRR
JMdx1TXV/UMTT+98/cBQKi6Q2RJTkjRVVRHSCALwNHTz5Jk9gY+eu47n2HA43N/f762sXL58uW61
30EKNUUS3/+n83YfmkjlSgCA4cnkfO7RJy7oWdbqEyXVZeOXtvqcVuNCThU4qSzOt5UsPEE5872T
XgJCx93OYTU+9K1/uPSWh8PxnE6J3cLd8on1qqqB+TMuJVn94j1Pqho6Z11z33B0IpoFAHznl38/
a1Xj9PjcifEymUxtbW2BQKBUKgmCoA/zTUwEEcJOm+3yzUtvuHJjMJTYfTi469DkWEwSNToq0EmJ
ChXBUCr5t70Rr41oDVQ01FTU+CtZhtYpwRhrmqYhhDQEAEYII6Tp/ruqqjpq5UxAACBBECzLuFwu
RdXGJ2N7+sd294XDeZgRKUE2STLSVEXDGoTYyACHASxvdG09f22lyzY+HsyQhN/vd7lcPM+Xexjv
bNjfZGS3nNb6m6f3AQBUFc1HgN9jufDMJada+MJWuszuvKfhE5SDj7fgZfG5Lb/+t62XfeVhfTzx
Z4++Vuuz63qLmKei7v7V9sFgwsyz37x+08HB8PXf+hMAIJEp3vPQy3fcsPnUjCNBEAzDmEwml8ul
zyHTg2HpdDoejw0ODjCsYWWr68INXZl8ac+RyTf6IkenSqLGRkuGpEJOifhIsmjaP8BTh20m0u8y
uRxms9FgMrImI2tgGZIkCIIgSYIkCE1DsqLKiiYpqqSosiJJiibJarYgxlNCOCUkckhQ6bxMCbJN
VLCiqkhV9FRHCmILh9q8zD9sWdfRWhsMBicnC4FAvdvt5jjuvZrxUU5/8Hss88UO9EGeU6UKLcjX
NLzwwj3HecvBWM/smMO/rHY++K+XX3nrI4IoAwDuuPeFBcJ7rx8M3v/4bgDAN6/fVOkyV7rMZyyv
f3nvKADgN0/tu3RTZ1eT9xQScqb32nTUjEajw+Hw+/367J1UKpVIJPbs2UMQRJPXecbyNRom9veH
3zwaOxwUBM2QUri0RpEkQcuwL4vpMUwTAgXzFIFJiCGEEGIIMAAAAwIBiDChYYAQ1DDQENAQkDWo
aCZFM8kqVlSkpz8ArBAAIYAxRiTETk49vd123dazk4n40OBgTU1NZWUlz/MzRqxPKE++fGR9T2DO
LBqE8Y59o/r22asb5ytBPhW8yjSUXbe5E++OaR11ntPwicrBbwUy5362rmbvvbd/9Np/+YOsakJJ
1rMmZ5OaL0pf/uGTGINz17WUx63/5fqN5/7jLxUVIYz/+T+efewHHydnebQnNY12Nmp6566urk4Q
hHQ6nUgkDh86rGqax+G49sOtvMncPxY7MJw6MJKLC5SCDAVswIiBBAUIiiBISBAQEuBtvQJ1Px4j
jJCGkYaRhpCKNQ0hVdNUTdMw0gisGSnRSIgMocbyoKBiI612VNH/eNXmkZFhu93e3Lxcz7R5Bxrr
ie19373/xS9+7ENbTm81Gt4efskVxDsffEmvd4/DdPV5y+drYPlYzsXJSJmGhaFE6ASnlfmb7wT9
8UR53mc7bWndj2654MY7Hy/7Z2iWJb3j3hemYjmXjf/2jedMG5h3Xnvhynu37QIA9A5GfvPUvo+f
3/NO8JoTNYIgKIrSVVpNTU2xWMxkMolEYnR0VCgKFrP1rE7nFRtb03lxZCo7GMoPhtKRLFCAQcMM
QjQCFIAkBgQGEAAMAYIYEVglkUZgBQKFgApBygCqeUQJiKSA7DTkTm81bV7baeTYG+5+VgCEhVE3
rGpPJOJut7uhoYHjuHdsCrec3vr864Nf/uFfb//ZcyuWVHldZgjAVDz3xqEJ+a3UBurnX/+oaVZC
S/mnXhKVU8DrWBOWJOVkbKgoqxjP4b+XUSjOUw4+NsC18Lt/Ky/e9u/PHBtxPo7U514b+OMLvQCA
7920xXF8f+XGK0577MXD+pDXPQ+9/OHT21w248niVZ4gpLvjZbcMHi86ZwaDwWaz+f1+URT1NKxE
Mjk2Pk6ShNlkPnOJ7dL1dSRJJTLFeKYUy0hZQVRUJKtYVpGmIZqCLEWwNGRpgmNpG89ZTayFZ1/Z
H/zja2kKU042f36P7bz1XYf7jtTUNUCMAMYU1FiaJEnS4/HontY79q4u3rAknirc/avtJUnZsXd0
xtFAleMnX7lwSUPFAmYuWxBPBa+31FJOkBY4jTumRzUNFUW5PMo0W71ljmX8zcnXCZ/tii1L07nS
3Q9tBwDI0/AKJ3K3/uRpAMD6nsDZqxpnJ4zceu2Gf/r+X/QXuf1nz/77Vy88bubEAmypqlosFvP5
vJ5TpeexcBxntVr1WfnTp7DqnOlBB4vFUllZqa8AkC8UctlsJpMNh0OKotA0YzCw9XYjU0ETBKlf
QhCEpmkIaaqGNFUVBCGXzVU3LDs8FH7mjZCoGm104YwW7iNnLdu9e3epVPJW1WoawtpbiUMLzPw5
JbnuktXnrGv+zVP7dh4Yn4xmEcJ2C7e6s/qiDUvWdNbOFw369MWrdN0QqHKc/L1uuGyt7k61BzwL
nLa81a/nJujGdzZeF5zRvqShcnpmzgw5e1Wjx2GymQ0nfqStax02YySRn57ccXg4evX5PQCATWvm
djovPLM9liro6RgUSQxOJFrr3n6jOWYK6fHMUqkUDofHx8d53mSzWU0mU0kUGZqmabpYLAGA7Xa7
zWYrEzaf5tOVnyzLepKMJEnFYlEURVVVNU0PU2AAAEESFElCCIvF4ujYWHNTkwIMP3p0f7jIc6S0
ph5+duv6sbExmqYSyaTHW3PzD55PFECFSbl6c8P61Z1ms9nv95MkCRbl/STUnO5kPp8fGBhMJpNN
TY3ByfBT254aGgtLssLQlNPKd7U3nLZmhR78dDgcczbqjN4ATdM8z5end5enT84gUhCE/v7+5uZm
xmD58cOvhQWOIaSOSvVTl2yYnJzw+30AgGw2JyuahjRNw0VJOzo8ef7GdfF43G636wPVi/Ow3794
IYQEQThy5Eg8Hl+ypOMXv972/I4DaUGRVQIQJE3TJmNhcCp3uH/4ysvOq/B49AmJC7conCdlZTpe
GONCoRAMBjUNOVwVdz64PZhhSKg02cXPXn5WIh51uVx+vz8SiRAkISsK0lRNw0JJHZrK9vYNtDTW
jY2Neb1em812qiGJRfmfE/Kb3/zm9DYuFouHDx9OJpNOd+Vt3/nZ09v3p/MSQRBGjuI5BmEYS4up
vCLKWjYZ7uleomkaz/PvzKcuaxpFUWKx2MDAAMuyaQH99NHXhxPQSMmbui3XXLiqWMi5XK7a2lqa
puPxeLFYygrqi7tHi6IiK6pQUkZGx5RSzuf1IE3LZrMkSb7LMP2i/I9oL03TdH9rxYqV133pO/v6
xmwWY3uD99KPbFq1vMNus/72zy9+++d/KRRRKEGE44WJialAoE6fdfPObq87ecHgRCg0VR8IPP78
m0++PpmVaJdRvPqctlXdDcGJieampoqKCoqiZFnO5/Nms2n3kUFJljVVBUgtYZzKI1nFmqqaTKZc
Ljc4ONjY2Gi1Whfxen/hpShKPB63WKzbX9vbOzDBc0xXk/erN32Kpoidr77S2NQcS6QAUgEiMFYB
QLzJqC8v+M7AQggVi8WxsbFkMllXH/jVn7ZBi/kUAAAHxElEQVS/eCAhKFSlqfSpi3raG/2Tk5Ot
LS1ut1tPLlUUJZ/P+3z+kYmYJClYVVkK1bqY67auX9fTPjAwEImELRaLvorEYtO+v/DCGMuynMlk
XS7X4y/sVlSt3ufYcNoyj9sZCoXMZnM+l1vZ3bzt6Z2Sgj0WurrSUVlRoWnaO7CMencyk8mMjIyo
qubzV//0oaffGMjJGlFtlz976dpqnzMSibS1tTmdTt2X0hcjKQiCyWQaDkZlRYZA85ipay5a29PR
MDAwUFNT43K59BSg9ypUsSjvpfZSVbVUKvI8PzYRoSnC4+DbW5s0TWtra+M4bv/+AytWrrj/7psP
Hx3hWOq01Uuz2ew7CAcghCRJisViY2Njbrc7L0h33vv4oYkShLCzirnhqo0URKlkckl7uz5prHxV
oVBgWXYiFE3nRE2VORq21ljPOr1naGiws7PT7XbPSHBdlPcXXnqoQNM0ACFNkTzH2KxWmqbNZnN9
fb0kSb0He01mU3uDl2GYaCRSVVVlNptPvi11pSUIwsTERCqVqq2tfeWN3t89vSeSAwYGru/2ffLS
s6PRiEaR7e3tVqt1esKqqqqpVMput+/afzQnSEhVTCZ6RWd9Pp/z+/0ej2f2qiSL8v7CSx/zURTF
zL81eKcoij6ZwmazdXV1+f3+XC4nSRLP8y6Xy263n6SXo8cgZFlOJpOjo6MGg8FTUXnvb/76yoGp
vAQdPLH1nKWbz+gZGR3xuN11dXWzI1iiKMYTiZbm5p17/iIURYA0s4FuaaiRJEl3/BfZer/jRVGU
gTWkM+mO1sCruw+VJCWeTPr9PkVROI4zmUxGo1HTNIxxeTDnJNlSVTWfz09NTWUyWa/POzI+ddd9
jw+HSwjAJq/pM1vPqq3yDA8P19fX+Xw+g8EwO0ImCIKqqHmhOBSMSZJEkdjCkXU1/mwmPd+0n0V5
H+EFIWQYxmIxT0xM9nS1IIQSaWHvvoPLl3ZnMhl9sT+SJE/J09K7h6VSKRqNTk1N2e12l8v9uz89
/8IbR1N5xBuoM1cGrrlscyadioTD7e1t0ycIzXDX8vk8zxv7B8ez+aKqSEaa8rrMZhNfFAo0vbjs
1gdEe9ls9v0HDq5YuTJQ6wvFEgOjU6/temPdmtWJRMLhcDAMczKOs24K9aHGdDo9MTFBEERNTc3L
r+3d9vSrE7GigmCVm//ER89cvbx9eHjY4XA0NzfPXhRpuvLLZDIWi+XF1w8XhBLSZJOBWbm0NZPJ
LIbpPzB4kSTpdDrcLldfX981l2/55zv/q38k9uzfXuFYw7Jl3eFwWF+GuZyTMydV+uo6pVJJT2cl
CMLj8YxNhO77wf0HB8O5kmYxMpvWtl592TmqLA4PD9fX13u93tkGcUZALpvN1dfX9R0dLZVEEiC3
lVnd05XP571e77vJw1mU/1XX3mq11tRU735zz+bNmzd+qOeFHXsghLLybCQa3XDmGfqylPpMxulJ
oeW/ddGTvdLptKIoRiNfUVHR1z/4xyf+9tq+gXhWoiiyM1DxicvOaWuuGxkdNZtM3d3dVqv1hJ0+
RVFKpSLHccGpiKZIFhPb1VLjdjmi0eii4/VBwothmMbGxlwu99JLL91ywz/4Kt2/f+JvO/aOjE4m
t7+2v2dpW3dHW2WFx2h8OylRTzbUp45BCEVRTGfyU+Fo38DIwb7hREZQVORy2C7dsmzdys4Kp0UQ
iolEor2tzel06jP9T7gSuCiKEMJEMp0vFBkKNFU7PnHFRZOTk4FA4IQLiS/K+wUv3T7a7fZly5aR
JLlz586PbFp16QVn3vadn/f2j41MpXoHp7wv7fbYTXXV3taWBrvNxnEGmqZz+UI8kYrFEkNjE8Gp
eCZf0jPs7Fb+3DNXbfjQyrpqXygczqTTCJmam5usVutJunFlvBiGCUViqqp53eZPXnE+y1CcwarH
9Bdb8X0rc6cTapqWTqcHBgb6+o5YbbYVPT07Xt//28ee6+0fgwBwBtrCG0xGhqEpioQIA0lWRVmR
ZU3VECSg1cQt72xZt6p75bKOTDYTi8VURfH5fD6fz2q16tNZT/4RVVUdGBiIxWLjU4kf/9ejq5c2
f/WmT4+OjnZ1ddnt9kXH6wOGV9nkCYIQDAYHBgaisVhVVXVba8vYRGTPwf6BoeCRobFUOqerHwJC
koQmnmus8y3rbF3a0RKoq8pks6lkMpfL2e12r9frcDhMJpOeTn2qtkyW5cOHDxcKhcGRyVd27fny
jZ+Kx2N+v7+2tnYxmvpBxQscWzIkk8mEQqGJiYloLGaz2e12m91md7lcCCNZVhRF1ZBmNplYhtZX
R8pkMpIk6YvXu1wui8Wiq6t3rGYkSTp48KCqqslUpq62JpVK8jzf2tp6wjTGRXlf4wWm/Yeejo6+
VG4ulysIReLtaUKk/s8aFovF4XDY7Xar1To9c+HdQIAxliRp7969NE37fL6jR48ajcbW1laLxbJo
Fj/weE3XZHrooTwpQ1VV/Us9lZ6maX39rekW8N1rF92v37NnD4QwnU77fL5AIGA2mxc9+g9kz3E+
0a0bSZIsy5rN5vJEDD0Ta85/unvPfgEQGo3GVCrV2to654jkonzgtdf/Q9EXzwEAzPlfQIuyiNe7
tY/TNdlimy3itSiLAgAAi52vRVnEa1E+mPLf1Up0+1WZESoAAAAASUVORK5CYII=
"""



if __name__=="__main__":

    save_logo_to_file( r'logo.png' ) # Normally a full path name

