import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
/**
 * Properties for PreinstalledAmazonLinuxInstance
 */
export interface PreinstalledAmazonLinuxInstanceProps extends ec2.InstanceProps {
    /**
     * The software to preinstall on the instance.
     *
     * @default - no software is preinstalled
     */
    readonly preinstalledSoftware?: PreinstalledSoftware;
}
/**
 * The type of preinstalled software.
 */
export declare enum PreinstalledSoftwarePackage {
    /**
     * Node.js
     */
    NODEJS = 0,
    /**
     * Docker
     */
    DOCKER = 1,
    /**
     * Visual Studio Code
     */
    VSCODE = 2,
    /**
     * Git
     */
    GIT = 3
}
/**
 * The configuration for preinstalled software.
 */
export interface PreinstalledSoftware {
    /**
     * The type of preinstalled software.
     *
     * @default - no software is preinstalled
     */
    readonly packages?: PreinstalledSoftwarePackage[];
    /**
     * Whether to install other software.
     * This is a list of software to install and passed to `dnf install <software>`
     *
     * @default - no other software is preinstalled
     */
    readonly others?: string[];
}
/**
 * Create an EC2 instance with preinstalled software.
 */
export declare class PreinstalledAmazonLinuxInstance extends ec2.Instance {
    constructor(scope: Construct, id: string, props: PreinstalledAmazonLinuxInstanceProps);
}
