"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreinstalledAmazonLinuxInstance = exports.PreinstalledSoftwarePackage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
;
/**
 * The type of preinstalled software.
 */
var PreinstalledSoftwarePackage;
(function (PreinstalledSoftwarePackage) {
    /**
     * Node.js
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["NODEJS"] = 0] = "NODEJS";
    /**
     * Docker
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["DOCKER"] = 1] = "DOCKER";
    /**
     * Visual Studio Code
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["VSCODE"] = 2] = "VSCODE";
    /**
     * Git
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["GIT"] = 3] = "GIT";
})(PreinstalledSoftwarePackage || (exports.PreinstalledSoftwarePackage = PreinstalledSoftwarePackage = {}));
/**
 * Create an EC2 instance with preinstalled software.
 */
class PreinstalledAmazonLinuxInstance extends ec2.Instance {
    constructor(scope, id, props) {
        if (!(props.machineImage instanceof ec2.AmazonLinuxImage)) {
            throw new Error('Only AMAZON_LINUX, AMAZON_LINUX_2, AMAZON_LINUX_2022, and AMAZON_LINUX_2023 are supported.');
        }
        const userData = props.userData ?? ec2.UserData.forLinux();
        if (props.preinstalledSoftware != null) {
            userData.addCommands('sudo dnf update -y');
            const preinstalledSoftware = props.preinstalledSoftware;
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.NODEJS)) {
                userData.addCommands('touch ~/.bashrc', 'curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.7/install.sh | bash', 'source ~/.bashrc', 'export NVM_DIR="$HOME/.nvm"', '[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"', 'nvm install --lts', `cat <<EOF >> /home/ec2-user/.bashrc
export NVM_DIR="/.nvm"
[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
EOF`);
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.DOCKER)) {
                userData.addCommands('sudo amazon-linux-extras install docker', 'sudo systemctl start docker', 'sudo systemctl enable docker', 'sudo usermod -a -G docker ec2-user');
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.VSCODE)) {
                userData.addCommands('sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc', 'echo -e "[code]\nname=Visual Studio Code\nbaseurl=https://packages.microsoft.com/yumrepos/vscode\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" | sudo tee /etc/yum.repos.d/vscode.repo > /dev/null', 'sudo dnf check-update', 'sudo dnf install -y code');
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.GIT)) {
                userData.addCommands('sudo dnf install -y git');
            }
            if (preinstalledSoftware.others) {
                userData.addCommands(`sudo dnf install -y ${preinstalledSoftware.others.join(' ')}`);
            }
        }
        const { preinstalledSoftware, ...rest } = props;
        super(scope, id, { ...rest, userData: userData });
    }
}
exports.PreinstalledAmazonLinuxInstance = PreinstalledAmazonLinuxInstance;
_a = JSII_RTTI_SYMBOL_1;
PreinstalledAmazonLinuxInstance[_a] = { fqn: "cdk-preinstalled-amazon-linux-ec2.PreinstalledAmazonLinuxInstance", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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