import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageShareConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#metadata DataAzurermStorageShare#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#name DataAzurermStorageShare#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#storage_account_name DataAzurermStorageShare#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * acl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#acl DataAzurermStorageShare#acl}
     *
     * @stability stable
     */
    readonly acl?: DataAzurermStorageShareAcl[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#timeouts DataAzurermStorageShare#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageShareTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageShareAcl {
}
export declare function dataAzurermStorageShareAclToTerraform(struct?: DataAzurermStorageShareAcl): any;
/**
 * @stability stable
 */
export interface DataAzurermStorageShareTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html#read DataAzurermStorageShare#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageShareTimeoutsToTerraform(struct?: DataAzurermStorageShareTimeoutsOutputReference | DataAzurermStorageShareTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageShareTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageShareTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html azurerm_storage_share}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageShare extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share.html azurerm_storage_share} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageShareConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get quota(): number;
    /**
     * @stability stable
     */
    get resourceManagerId(): string;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _acl?;
    /**
     * @stability stable
     */
    get acl(): DataAzurermStorageShareAcl[];
    /**
     * @stability stable
     */
    set acl(value: DataAzurermStorageShareAcl[]);
    /**
     * @stability stable
     */
    resetAcl(): void;
    /**
     * @stability stable
     */
    get aclInput(): DataAzurermStorageShareAcl[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageShareTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageShareTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageShareTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
