import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVmwarePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html#name DataAzurermVmwarePrivateCloud#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html#resource_group_name DataAzurermVmwarePrivateCloud#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html#timeouts DataAzurermVmwarePrivateCloud#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVmwarePrivateCloudTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVmwarePrivateCloudCircuit extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get expressRouteId(): string;
    /**
     * @stability stable
     */
    get expressRoutePrivatePeeringId(): string;
    /**
     * @stability stable
     */
    get primarySubnetCidr(): string;
    /**
     * @stability stable
     */
    get secondarySubnetCidr(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVmwarePrivateCloudManagementCluster extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hosts(): string[];
    /**
     * @stability stable
     */
    get id(): number;
    /**
     * @stability stable
     */
    get size(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermVmwarePrivateCloudTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html#read DataAzurermVmwarePrivateCloud#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVmwarePrivateCloudTimeoutsToTerraform(struct?: DataAzurermVmwarePrivateCloudTimeoutsOutputReference | DataAzurermVmwarePrivateCloudTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVmwarePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVmwarePrivateCloudTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVmwarePrivateCloudTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html azurerm_vmware_private_cloud}.
 *
 * @stability stable
 */
export declare class DataAzurermVmwarePrivateCloud extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud.html azurerm_vmware_private_cloud} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVmwarePrivateCloudConfig);
    /**
     * @stability stable
     */
    circuit(index: string): DataAzurermVmwarePrivateCloudCircuit;
    /**
     * @stability stable
     */
    get hcxCloudManagerEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internetConnectionEnabled(): any;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    managementCluster(index: string): DataAzurermVmwarePrivateCloudManagementCluster;
    /**
     * @stability stable
     */
    get managementSubnetCidr(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkSubnetCidr(): string;
    /**
     * @stability stable
     */
    get nsxtCertificateThumbprint(): string;
    /**
     * @stability stable
     */
    get nsxtManagerEndpoint(): string;
    /**
     * @stability stable
     */
    get provisioningSubnetCidr(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get vcenterCertificateThumbprint(): string;
    /**
     * @stability stable
     */
    get vcsaEndpoint(): string;
    /**
     * @stability stable
     */
    get vmotionSubnetCidr(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVmwarePrivateCloudTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVmwarePrivateCloudTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVmwarePrivateCloudTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
