import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoScriptConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#continue_on_errors_enabled KustoScript#continue_on_errors_enabled}.
     *
     * @stability stable
     */
    readonly continueOnErrorsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#database_id KustoScript#database_id}.
     *
     * @stability stable
     */
    readonly databaseId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#force_an_update_when_value_changed KustoScript#force_an_update_when_value_changed}.
     *
     * @stability stable
     */
    readonly forceAnUpdateWhenValueChanged?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#name KustoScript#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#sas_token KustoScript#sas_token}.
     *
     * @stability stable
     */
    readonly sasToken: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#url KustoScript#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#timeouts KustoScript#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoScriptTimeouts;
}
/**
 * @stability stable
 */
export interface KustoScriptTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#create KustoScript#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#delete KustoScript#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#read KustoScript#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html#update KustoScript#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoScriptTimeoutsToTerraform(struct?: KustoScriptTimeoutsOutputReference | KustoScriptTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoScriptTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoScriptTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoScriptTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html azurerm_kusto_script}.
 *
 * @stability stable
 */
export declare class KustoScript extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script.html azurerm_kusto_script} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoScriptConfig);
    private _continueOnErrorsEnabled?;
    /**
     * @stability stable
     */
    get continueOnErrorsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set continueOnErrorsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContinueOnErrorsEnabled(): void;
    /**
     * @stability stable
     */
    get continueOnErrorsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _databaseId?;
    /**
     * @stability stable
     */
    get databaseId(): string;
    /**
     * @stability stable
     */
    set databaseId(value: string);
    /**
     * @stability stable
     */
    get databaseIdInput(): string | undefined;
    private _forceAnUpdateWhenValueChanged?;
    /**
     * @stability stable
     */
    get forceAnUpdateWhenValueChanged(): string;
    /**
     * @stability stable
     */
    set forceAnUpdateWhenValueChanged(value: string);
    /**
     * @stability stable
     */
    resetForceAnUpdateWhenValueChanged(): void;
    /**
     * @stability stable
     */
    get forceAnUpdateWhenValueChangedInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sasToken?;
    /**
     * @stability stable
     */
    get sasToken(): string;
    /**
     * @stability stable
     */
    set sasToken(value: string);
    /**
     * @stability stable
     */
    get sasTokenInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoScriptTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoScriptTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoScriptTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
