import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogAnalyticsLinkedServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#linked_service_name LogAnalyticsLinkedService#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#read_access_id LogAnalyticsLinkedService#read_access_id}.
     *
     * @stability stable
     */
    readonly readAccessId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#resource_group_name LogAnalyticsLinkedService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#resource_id LogAnalyticsLinkedService#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#tags LogAnalyticsLinkedService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#workspace_id LogAnalyticsLinkedService#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#workspace_name LogAnalyticsLinkedService#workspace_name}.
     *
     * @stability stable
     */
    readonly workspaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#write_access_id LogAnalyticsLinkedService#write_access_id}.
     *
     * @stability stable
     */
    readonly writeAccessId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#timeouts LogAnalyticsLinkedService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogAnalyticsLinkedServiceTimeouts;
}
/**
 * @stability stable
 */
export interface LogAnalyticsLinkedServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#create LogAnalyticsLinkedService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#delete LogAnalyticsLinkedService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#read LogAnalyticsLinkedService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html#update LogAnalyticsLinkedService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logAnalyticsLinkedServiceTimeoutsToTerraform(struct?: LogAnalyticsLinkedServiceTimeoutsOutputReference | LogAnalyticsLinkedServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class LogAnalyticsLinkedServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogAnalyticsLinkedServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogAnalyticsLinkedServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html azurerm_log_analytics_linked_service}.
 *
 * @stability stable
 */
export declare class LogAnalyticsLinkedService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_linked_service.html azurerm_log_analytics_linked_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogAnalyticsLinkedServiceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    resetLinkedServiceName(): void;
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _readAccessId?;
    /**
     * @stability stable
     */
    get readAccessId(): string;
    /**
     * @stability stable
     */
    set readAccessId(value: string);
    /**
     * @stability stable
     */
    resetReadAccessId(): void;
    /**
     * @stability stable
     */
    get readAccessIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    resetResourceId(): void;
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    resetWorkspaceId(): void;
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _workspaceName?;
    /**
     * @stability stable
     */
    get workspaceName(): string;
    /**
     * @stability stable
     */
    set workspaceName(value: string);
    /**
     * @stability stable
     */
    resetWorkspaceName(): void;
    /**
     * @stability stable
     */
    get workspaceNameInput(): string | undefined;
    private _writeAccessId?;
    /**
     * @stability stable
     */
    get writeAccessId(): string;
    /**
     * @stability stable
     */
    set writeAccessId(value: string);
    /**
     * @stability stable
     */
    resetWriteAccessId(): void;
    /**
     * @stability stable
     */
    get writeAccessIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogAnalyticsLinkedServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogAnalyticsLinkedServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogAnalyticsLinkedServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
