import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateLinkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#auto_approval_subscription_ids PrivateLinkService#auto_approval_subscription_ids}.
     *
     * @stability stable
     */
    readonly autoApprovalSubscriptionIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#enable_proxy_protocol PrivateLinkService#enable_proxy_protocol}.
     *
     * @stability stable
     */
    readonly enableProxyProtocol?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#load_balancer_frontend_ip_configuration_ids PrivateLinkService#load_balancer_frontend_ip_configuration_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerFrontendIpConfigurationIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#location PrivateLinkService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#name PrivateLinkService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#resource_group_name PrivateLinkService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#tags PrivateLinkService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#visibility_subscription_ids PrivateLinkService#visibility_subscription_ids}.
     *
     * @stability stable
     */
    readonly visibilitySubscriptionIds?: string[];
    /**
     * nat_ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#nat_ip_configuration PrivateLinkService#nat_ip_configuration}
     *
     * @stability stable
     */
    readonly natIpConfiguration: PrivateLinkServiceNatIpConfiguration[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#timeouts PrivateLinkService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivateLinkServiceTimeouts;
}
/**
 * @stability stable
 */
export interface PrivateLinkServiceNatIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#name PrivateLinkService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#primary PrivateLinkService#primary}.
     *
     * @stability stable
     */
    readonly primary: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#private_ip_address PrivateLinkService#private_ip_address}.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#private_ip_address_version PrivateLinkService#private_ip_address_version}.
     *
     * @stability stable
     */
    readonly privateIpAddressVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#subnet_id PrivateLinkService#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function privateLinkServiceNatIpConfigurationToTerraform(struct?: PrivateLinkServiceNatIpConfiguration): any;
/**
 * @stability stable
 */
export interface PrivateLinkServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#create PrivateLinkService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#delete PrivateLinkService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#read PrivateLinkService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html#update PrivateLinkService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privateLinkServiceTimeoutsToTerraform(struct?: PrivateLinkServiceTimeoutsOutputReference | PrivateLinkServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class PrivateLinkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateLinkServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateLinkServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html azurerm_private_link_service}.
 *
 * @stability stable
 */
export declare class PrivateLinkService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_link_service.html azurerm_private_link_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateLinkServiceConfig);
    /**
     * @stability stable
     */
    get alias(): string;
    private _autoApprovalSubscriptionIds?;
    /**
     * @stability stable
     */
    get autoApprovalSubscriptionIds(): string[];
    /**
     * @stability stable
     */
    set autoApprovalSubscriptionIds(value: string[]);
    /**
     * @stability stable
     */
    resetAutoApprovalSubscriptionIds(): void;
    /**
     * @stability stable
     */
    get autoApprovalSubscriptionIdsInput(): string[] | undefined;
    private _enableProxyProtocol?;
    /**
     * @stability stable
     */
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableProxyProtocol(): void;
    /**
     * @stability stable
     */
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancerFrontendIpConfigurationIds?;
    /**
     * @stability stable
     */
    get loadBalancerFrontendIpConfigurationIds(): string[];
    /**
     * @stability stable
     */
    set loadBalancerFrontendIpConfigurationIds(value: string[]);
    /**
     * @stability stable
     */
    get loadBalancerFrontendIpConfigurationIdsInput(): string[] | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _visibilitySubscriptionIds?;
    /**
     * @stability stable
     */
    get visibilitySubscriptionIds(): string[];
    /**
     * @stability stable
     */
    set visibilitySubscriptionIds(value: string[]);
    /**
     * @stability stable
     */
    resetVisibilitySubscriptionIds(): void;
    /**
     * @stability stable
     */
    get visibilitySubscriptionIdsInput(): string[] | undefined;
    private _natIpConfiguration?;
    /**
     * @stability stable
     */
    get natIpConfiguration(): PrivateLinkServiceNatIpConfiguration[];
    /**
     * @stability stable
     */
    set natIpConfiguration(value: PrivateLinkServiceNatIpConfiguration[]);
    /**
     * @stability stable
     */
    get natIpConfigurationInput(): PrivateLinkServiceNatIpConfiguration[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivateLinkServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivateLinkServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivateLinkServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
