"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwesomeList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
/**
 * Awesome List project
 *
 * @pjid awesome-list
 */
class AwesomeList extends projen_1.cdk.JsiiProject {
    constructor(options) {
        var _b;
        super({
            ...options,
            readme: {
                filename: "readme.md",
                contents: readmeContents(),
            },
            defaultReleaseBranch: "main",
            gitpod: true,
            releaseToNpm: false,
        });
        new projen_1.SampleFile(this, "code-of-conduct.md", {
            contents: this.codeOfConduct().replace("CONTACTEMAIL", (_b = options.contactEmail) !== null && _b !== void 0 ? _b : "noreply@example.com"),
        });
        new projen_1.SampleFile(this, "contributing.md", {
            contents: this.contributing(),
        });
        this._awesomeLint();
    }
    _awesomeLint() {
        this.addDevDeps("awesome-lint");
        const awesomeLintTask = this.addTask("awesome-lint");
        awesomeLintTask.exec("npx awesome-lint");
        this.postCompileTask.spawn(awesomeLintTask);
    }
    codeOfConduct() {
        return `# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at CONTACTEMAIL. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
    `;
    }
    contributing() {
        return `# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

## Adding an awesome list

Please ensure your pull request adheres to the [list guidelines](pull_request_template.md).

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
    `;
    }
}
exports.AwesomeList = AwesomeList;
_a = JSII_RTTI_SYMBOL_1;
AwesomeList[_a] = { fqn: "p6-projen-project-awesome-list.AwesomeList", version: "1.0.11" };
function readmeContents() {
    return `# Awesome Projen [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

  > Curated list of awesome [PROJECT](REPOSITORY) SHORTDESC.

  LONGDESC

  ## Contents

  ## Contributing

  Contributions welcome! Read the [contribution guidelines](contributing.md) first.`;
}
//# sourceMappingURL=data:application/json;base64,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