from typing import Union

from .c.c_ppmd import *
from .cffi.cffi_ppmd import *

msg: str
__doc__: str

def compress(data: Union[bytes, bytearray, memoryview, str], max_order: int = ..., mem_size: int = ...) -> bytes: ...
def decompress(
    data: Union[bytes, bytearray, memoryview], length: int, max_order: int = ..., mem_size: int = ..., encoding: str = ...
) -> Union[bytes, str]: ...

from typing import Any, Union

class PpmdError(Exception): ...

class PpmdBaseEncoder:
    def __init__(self) -> None: ...
    def encode(self, data: Any) -> bytes: ...
    def flush(self) -> bytes: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, type: Any, value: Any, traceback: Any) -> None: ...

class PpmdBaseDecoder:
    def __init__(self) -> None: ...

class Ppmd7Encoder(PpmdBaseEncoder):
    def __init__(self, max_order: int, mem_size: int) -> None: ...
    def encode(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self) -> bytes: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, type: Any, value: Any, traceback: Any) -> None: ...

class Ppmd7Decoder(PpmdBaseDecoder):
    def __init__(self, max_order: int, mem_size: int) -> None: ...
    def decode(self, data: Union[bytes, bytearray, memoryview], length: int) -> bytes: ...
    def flush(self, length: int) -> bytes: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class Ppmd8Encoder(PpmdBaseEncoder):
    def __init__(self, max_order: Any, mem_size: Any) -> None: ...
    def encode(self, data: Union[bytes, bytearray, memoryview]) -> bytes: ...
    def flush(self) -> bytes: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, type: Any, value: Any, traceback: Any) -> None: ...

class Ppmd8Decoder(PpmdBaseDecoder):
    def __init__(self, max_order: int, mem_size: int) -> None: ...
    def decode(self, data: Union[bytes, bytearray, memoryview], length: int) -> Any: ...
    def flush(self, length: int) -> Any: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
