from django.template import Library

from meringue.thumbnail.shortcuts import get_thumbnail


register = Library()


@register.filter
def thumbnail(filename, args=""):
    """
        Фильтр обработки изображений, применяется к адресу изображения (путь до файла) в аргументах
    ожидает параметры изменения изображения разделённые запятой, последовательность действий
    соответствует последовательности введённых аргументов.
    Например:
        * последовательность s:600x400,resize,s:400x400,crop - сначала задас целевой размер
    изображения 600x400, далее  скукожит (или растянет изображение в зависимости от исходного и
    других параметров) до 600x400, потом установит новый целевой размер 400x400 и последним этапом
    будет обезание изображения в размер 400x400.
        * последовательность crop,s:400x400 не даст никакого результата, потому что новый размер
    указывается после события кропа (если параметры поменять местами, то изображение обрежется до
    квадрата 400x400).

    Аргументы фильтра:
        s:<width>x<height> - указывает целевой размер изображения для
            последующих функций
        maxw:<width> - указывает максимальную ширину
        maxh:<height> - указывает максимальную высоту
        crop - изменения размера холста до последнего установленного
        resize - изменение размера изображения до последнего установленного
        c:<color> - цвет заливки для кропа в формате rgba
            (c:255 255 255 255)
        cm:left|center|rigth top|bottom - точка отсчёта для кропа
        rm:cover|contain|stretch - метод ресайза вписать в размер или
            растянуть
        rs:no_increase|standart|no_reduce - стратегия ресайза - не давать увеличивать исходное
            изображение или уменьшать
    """

    task_list = args.split(",")
    return get_thumbnail(filename=filename, task_list=task_list)
