# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/07-cli-rebuild.ipynb (unless otherwise specified).

__all__ = ['app', 'rebuild_library']

# Cell
import typer
import shutil
import pandas as pd
from fastcore.foundation import Config

from .dev import utils, specgen, rawgen, clientgen

# Cell
app = typer.Typer()

# Cell
@app.command()
def rebuild_library():
    lib_path = str(Config().path('lib_path'))
    dir_root = f'{lib_path}/..'
    endpoints_fp = f'{dir_root}/data/endpoints.csv'

    shutil.rmtree(lib_path)
    utils.prepare_nbdev_module()
    utils.notebook2script()

    df_endpoints = specgen.load_endpoints_df(endpoints_fp)
    API_spec = specgen.construct_spec(df_endpoints)

    specgen.save_spec(
        API_spec,
        in_fp=f'{dir_root}/templates/open_api_spec.yaml',
        out_fp=f'{dir_root}/data/BMRS_API.yaml'
    )

    rawgen.save_methods(
        functions=rawgen.construct_all_functions(specgen.load_API_yaml(fp=f'{dir_root}/data/BMRS_API.yaml')),
        in_fp=f'{dir_root}/templates/raw_methods.py',
        out_fp=f'{dir_root}/ElexonDataPortal/dev/raw.py'
    )

    clientgen.save_api(
        API_yaml_fp=f'{dir_root}/data/BMRS_API.yaml',
        in_fp=f'{dir_root}/templates/api.py',
        out_fp=f'{dir_root}/ElexonDataPortal/api.py'
    )

    utils.add_extra_code_desc_to_mod()

    return

# Cell
if __name__ == '__main__' and '__file__' in globals():
    app()