/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.siemens.ct.exi.main.cmd.ReferenceURIDigestPair;
import com.siemens.ct.exi.main.messages.iso15118_2.CanonicalizationMethodType;
import com.siemens.ct.exi.main.messages.iso15118_2.CertificateChainType;
import com.siemens.ct.exi.main.messages.iso15118_2.ConsumptionCostType;
import com.siemens.ct.exi.main.messages.iso15118_2.ContractSignatureEncryptedPrivateKeyType;
import com.siemens.ct.exi.main.messages.iso15118_2.CostKindType;
import com.siemens.ct.exi.main.messages.iso15118_2.CostType;
import com.siemens.ct.exi.main.messages.iso15118_2.DiffieHellmanPublickeyType;
import com.siemens.ct.exi.main.messages.iso15118_2.DigestMethodType;
import com.siemens.ct.exi.main.messages.iso15118_2.EMAIDType;
import com.siemens.ct.exi.main.messages.iso15118_2.PhysicalValueType;
import com.siemens.ct.exi.main.messages.iso15118_2.ReferenceType;
import com.siemens.ct.exi.main.messages.iso15118_2.RelativeTimeIntervalType;
import com.siemens.ct.exi.main.messages.iso15118_2.SalesTariffEntryType;
import com.siemens.ct.exi.main.messages.iso15118_2.SalesTariffType;
import com.siemens.ct.exi.main.messages.iso15118_2.SignatureMethodType;
import com.siemens.ct.exi.main.messages.iso15118_2.SignedInfoType;
import com.siemens.ct.exi.main.messages.iso15118_2.TransformType;
import com.siemens.ct.exi.main.messages.iso15118_2.TransformsType;
import com.siemens.ct.exi.main.messages.iso15118_2.UnitSymbolType;
import com.siemens.ct.exi.main.messages.iso15118_20.commonmessages.ContractCertificateChainType;
import com.siemens.ct.exi.main.messages.iso15118_20.commonmessages.PnCAReqAuthorizationModeType;
import com.siemens.ct.exi.main.messages.iso15118_20.commonmessages.SignedCertificateChainType;
import com.siemens.ct.exi.main.messages.iso15118_20.commonmessages.SubCertificatesType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecurityPayloads {
    private static List<ReferenceURIDigestPair> GetURIDigestPairs(String json) {
        JSONObject sit;
        ArrayList<ReferenceURIDigestPair> pairs = new ArrayList<ReferenceURIDigestPair>();
        JSONObject jo = new JSONObject(json);
        if (jo.has("SignedInfo") && (sit = jo.getJSONObject("SignedInfo")).has("Reference")) {
            JSONArray ja = sit.getJSONArray("Reference");
            for (Object o : ja) {
                String uri = ((JSONObject)o).getString("URI");
                byte[] digestValueBase64 = Base64.getDecoder().decode(((JSONObject)o).getString("DigestValue"));
                pairs.add(new ReferenceURIDigestPair(uri, digestValueBase64));
            }
        }
        return pairs;
    }

    static SignedInfoType GetSignedInfo(String json) {
        DigestMethodType digestMethod = new DigestMethodType();
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        TransformType transform = new TransformType();
        transform.setAlgorithm("http://www.w3.org/TR/canonical-exi/");
        TransformsType transforms = new TransformsType();
        transforms.getTransform().add(transform);
        ArrayList<ReferenceType> references = new ArrayList<ReferenceType>();
        List<ReferenceURIDigestPair> uriDigestPairs = SecurityPayloads.GetURIDigestPairs(json);
        for (ReferenceURIDigestPair urp : uriDigestPairs) {
            ReferenceType reference = new ReferenceType();
            reference.setDigestMethod(digestMethod);
            reference.setTransforms(transforms);
            reference.setDigestValue(urp.DigestValue);
            reference.setURI(urp.URI);
            references.add(reference);
        }
        CanonicalizationMethodType canonicalizationMethod = new CanonicalizationMethodType();
        canonicalizationMethod.setAlgorithm("http://www.w3.org/TR/canonical-exi/");
        SignatureMethodType signatureMethod = new SignatureMethodType();
        signatureMethod.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        SignedInfoType signedInfo = new SignedInfoType();
        signedInfo.setCanonicalizationMethod(canonicalizationMethod);
        signedInfo.setSignatureMethod(signatureMethod);
        signedInfo.getReference().addAll(references);
        return signedInfo;
    }

    static CertificateChainType getContractSignatureChain(String json) {
        CertificateChainType cct = new CertificateChainType();
        JSONObject jo = new JSONObject(json);
        if (jo.has("ContractSignatureCertChain")) {
            JSONObject ccctJO = jo.getJSONObject("ContractSignatureCertChain");
            if (ccctJO.has("Id")) {
                cct.setId(ccctJO.getString("Id"));
            }
            if (ccctJO.has("Certificate")) {
                cct.setCertificate(Base64.getDecoder().decode(ccctJO.getString("Certificate")));
            }
            com.siemens.ct.exi.main.messages.iso15118_2.SubCertificatesType sct = new com.siemens.ct.exi.main.messages.iso15118_2.SubCertificatesType();
            if (ccctJO.has("SubCertificates")) {
                JSONArray arr = ccctJO.getJSONArray("SubCertificates");
                for (Object item : arr) {
                    sct.getCertificate().add(Base64.getDecoder().decode((String)((JSONObject)item).get("Certificate")));
                }
                cct.setSubCertificates(sct);
            }
        }
        return cct;
    }

    static CertificateChainType getContractSignatureChain_Modded(String json) {
        CertificateChainType cct = new CertificateChainType();
        JSONObject jo = new JSONObject(json);
        if (jo.has("ContractSignatureCertChain")) {
            JSONObject subCert;
            JSONObject ccctJO = jo.getJSONObject("ContractSignatureCertChain");
            if (ccctJO.has("Id")) {
                cct.setId(ccctJO.getString("Id"));
            }
            if (ccctJO.has("Certificate")) {
                cct.setCertificate(Base64.getDecoder().decode(ccctJO.getString("Certificate")));
            }
            com.siemens.ct.exi.main.messages.iso15118_2.SubCertificatesType sct = new com.siemens.ct.exi.main.messages.iso15118_2.SubCertificatesType();
            if (ccctJO.has("SubCertificates") && (subCert = ccctJO.getJSONObject("SubCertificates")).has("Certificate")) {
                JSONArray arr = subCert.getJSONArray("Certificate");
                for (Object item : arr) {
                    sct.getCertificate().add(Base64.getDecoder().decode((String)item));
                }
                cct.setSubCertificates(sct);
            }
        }
        return cct;
    }

    static ContractSignatureEncryptedPrivateKeyType GetContractSignatureEncryptedPrivateKey(String json) {
        ContractSignatureEncryptedPrivateKeyType csepk = new ContractSignatureEncryptedPrivateKeyType();
        JSONObject jo = new JSONObject(json);
        if (jo.has("ContractSignatureEncryptedPrivateKey")) {
            JSONObject csepkJO = jo.getJSONObject("ContractSignatureEncryptedPrivateKey");
            if (csepkJO.has("Id")) {
                csepk.setId(csepkJO.getString("Id"));
            }
            if (csepkJO.has("value")) {
                csepk.setValue(Base64.getDecoder().decode(csepkJO.getString("value")));
            }
        }
        return csepk;
    }

    static EMAIDType GetEMAIDType(String json) {
        EMAIDType emaidType = new EMAIDType();
        JSONObject jo = new JSONObject(json);
        if (jo.has("eMAID")) {
            JSONObject emJO = jo.getJSONObject("eMAID");
            if (emJO.has("Id")) {
                emaidType.setId(emJO.getString("Id"));
            }
            if (emJO.has("value")) {
                emaidType.setValue(emJO.getString("value"));
            }
        }
        return emaidType;
    }

    static DiffieHellmanPublickeyType GetDHPublicKey(String jsonDocument) {
        DiffieHellmanPublickeyType dhpky = new DiffieHellmanPublickeyType();
        JSONObject jo = new JSONObject(jsonDocument);
        if (jo.has("DHpublickey")) {
            JSONObject dhpkyJO = jo.getJSONObject("DHpublickey");
            if (dhpkyJO.has("Id")) {
                dhpky.setId(dhpkyJO.getString("Id"));
            }
            if (dhpkyJO.has("value")) {
                dhpky.setValue(Base64.getDecoder().decode(dhpkyJO.getString("value")));
            }
        }
        return dhpky;
    }

    static SignedCertificateChainType GetSignedCertificateChainType_15118_20(String jsonDocument) {
        SignedCertificateChainType scct = new SignedCertificateChainType();
        JSONObject rootObject = new JSONObject(jsonDocument);
        JSONObject jo = rootObject.getJSONObject("OEMProvisioningCertificateChain");
        if (jo.has("Id")) {
            scct.setId(jo.getString("Id"));
        }
        if (jo.has("Certificate")) {
            scct.setCertificate(SecurityPayloads.convertToByteArray(jo.getString("Certificate")));
        }
        if (jo.has("SubCertificates")) {
            SubCertificatesType sct = new SubCertificatesType();
            JSONObject subCert = jo.getJSONObject("SubCertificates");
            if (subCert.has("Certificate")) {
                JSONArray arr = subCert.getJSONArray("Certificate");
                for (Object item : arr) {
                    sct.getCertificate().add(Base64.getDecoder().decode((String)item));
                }
                scct.setSubCertificates(sct);
            }
        }
        return scct;
    }

    static PnCAReqAuthorizationModeType GetPnCAReqAuthorizationMode_15118_20(String jsonDocument) {
        PnCAReqAuthorizationModeType pncAReq = new PnCAReqAuthorizationModeType();
        JSONObject rootObject = new JSONObject(jsonDocument);
        JSONObject jo = rootObject.getJSONObject("PnC_AReqAuthorizationMode");
        if (jo.has("Id")) {
            pncAReq.setId(jo.getString("Id"));
        }
        if (jo.has("GenChallenge")) {
            pncAReq.setGenChallenge(Base64.getDecoder().decode(jo.getString("GenChallenge")));
        }
        if (jo.has("ContractCertificateChain")) {
            pncAReq.setContractCertificateChain(SecurityPayloads.getContractSignatureChainType(jo.getJSONObject("ContractCertificateChain")));
        }
        return pncAReq;
    }

    static ContractCertificateChainType getContractSignatureChainType(JSONObject jo) {
        ContractCertificateChainType ccct = new ContractCertificateChainType();
        if (jo.has("Certificate")) {
            ccct.setCertificate(SecurityPayloads.convertToByteArray(jo.getString("Certificate")));
        }
        if (jo.has("SubCertificates")) {
            SubCertificatesType sct = new SubCertificatesType();
            JSONObject subCert = jo.getJSONObject("SubCertificates");
            if (subCert.has("Certificate")) {
                JSONArray arr = subCert.getJSONArray("Certificate");
                for (Object item : arr) {
                    sct.getCertificate().add(Base64.getDecoder().decode((String)item));
                }
                ccct.setSubCertificates(sct);
            }
        }
        return ccct;
    }

    static short convertToShort(int intVal) {
        short value = (short)Math.min(Math.max(intVal, Short.MIN_VALUE), Short.MAX_VALUE);
        return value;
    }

    static byte convertToByte(String base64encodedString) {
        byte[] destinationByteArray = Base64.getDecoder().decode(base64encodedString);
        return destinationByteArray[0];
    }

    static byte[] convertToByteArray(String base64encodedString) {
        return Base64.getDecoder().decode(base64encodedString);
    }

    static SalesTariffType GetSalesTariffType(String jsonDocument) {
        SalesTariffType stt = new SalesTariffType();
        JSONObject st = new JSONObject(jsonDocument);
        if (st.has("SalesTariff")) {
            JSONObject jo = st.getJSONObject("SalesTariff");
            if (jo.has("Id")) {
                stt.setId(jo.getString("Id"));
            }
            if (jo.has("SalesTariffID")) {
                short value = SecurityPayloads.convertToShort(jo.getInt("SalesTariffID"));
                stt.setSalesTariffID(value);
            }
            if (jo.has("NumEPriceLevels")) {
                stt.setNumEPriceLevels(SecurityPayloads.convertToShort(jo.getInt("NumEPriceLevels")));
            }
            if (jo.has("SalesTariffDescription")) {
                stt.setSalesTariffDescription(jo.getString("SalesTariffDescription"));
            }
            if (jo.has("SalesTariffEntry")) {
                JSONArray salesTariffEntryArr = jo.getJSONArray("SalesTariffEntry");
                int i = 0;
                while (i < salesTariffEntryArr.length()) {
                    JSONObject salesTariffEntryObj = salesTariffEntryArr.getJSONObject(i);
                    SalesTariffEntryType stet = new SalesTariffEntryType();
                    if (salesTariffEntryObj.has("EPriceLevel")) {
                        stet.setEPriceLevel(SecurityPayloads.convertToShort(salesTariffEntryObj.getInt("EPriceLevel")));
                    }
                    if (salesTariffEntryObj.has("RelativeTimeInterval")) {
                        JSONObject relativeTimeInterval = salesTariffEntryObj.getJSONObject("RelativeTimeInterval");
                        RelativeTimeIntervalType rtit = new RelativeTimeIntervalType();
                        if (relativeTimeInterval.has("start")) {
                            rtit.setStart(relativeTimeInterval.getLong("start"));
                        }
                        if (relativeTimeInterval.has("duration")) {
                            rtit.setDuration(relativeTimeInterval.getLong("duration"));
                        }
                        String V2G_CI_MSG_DATATYPES_NAMESPACE = "urn:iso:15118:2:2013:MsgDataTypes";
                        JAXBElement<RelativeTimeIntervalType> jaxbElement = new JAXBElement<RelativeTimeIntervalType>(new QName(V2G_CI_MSG_DATATYPES_NAMESPACE, "RelativeTimeInterval"), rtit.getClass(), rtit);
                        stet.setTimeInterval(jaxbElement);
                    }
                    if (salesTariffEntryObj.has("ConsumptionCost")) {
                        JSONArray consumptionCostArr = salesTariffEntryObj.getJSONArray("ConsumptionCost");
                        int j = 0;
                        while (j < consumptionCostArr.length()) {
                            JSONObject cctObject = consumptionCostArr.getJSONObject(j);
                            ConsumptionCostType cct = new ConsumptionCostType();
                            if (cctObject.has("startValue")) {
                                JSONObject startValueObject = cctObject.getJSONObject("startValue");
                                PhysicalValueType pvt = new PhysicalValueType();
                                if (startValueObject.has("Multiplier")) {
                                    pvt.setMultiplier(SecurityPayloads.convertToByte(startValueObject.getString("Multiplier")));
                                }
                                if (startValueObject.has("Unit")) {
                                    pvt.setUnit(UnitSymbolType.fromValue(startValueObject.getString("Unit")));
                                }
                                if (startValueObject.has("Value")) {
                                    pvt.setValue(SecurityPayloads.convertToShort(startValueObject.getInt("Value")));
                                }
                                cct.setStartValue(pvt);
                            }
                            if (cctObject.has("Cost")) {
                                JSONArray costArray = cctObject.getJSONArray("Cost");
                                int k = 0;
                                while (k < costArray.length()) {
                                    JSONObject costArrayObj = costArray.getJSONObject(k);
                                    CostType ct = new CostType();
                                    if (costArrayObj.has("costKind")) {
                                        ct.setCostKind(CostKindType.fromValue(costArrayObj.getString("costKind")));
                                    }
                                    if (costArrayObj.has("amount")) {
                                        ct.setAmount(costArrayObj.getLong("costKind"));
                                    }
                                    if (costArrayObj.has("amountMultiplier")) {
                                        ct.setAmountMultiplier(SecurityPayloads.convertToByte(costArrayObj.getString("amountMultiplier")));
                                    }
                                    cct.getCost().add(ct);
                                    ++k;
                                }
                            }
                            stet.getConsumptionCost().add(cct);
                            ++j;
                        }
                    }
                    stt.getSalesTariffEntry().add(stet);
                    ++i;
                }
            }
        }
        return stt;
    }
}

