# generated by datamodel-codegen:
#   filename:  alfresco-discovery.yaml
#   timestamp: 2025-06-25T01:56:50+00:00

from __future__ import annotations

from datetime import datetime
from typing import Annotated

from pydantic import BaseModel, Field


class EntitlementsInfo(BaseModel):
    isClusterEnabled: bool | None = False
    isCryptodocEnabled: bool | None = False
    maxDocs: int | None = None
    maxUsers: int | None = None


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class LicenseInfo(BaseModel):
    entitlements: EntitlementsInfo | None = None
    expiresAt: datetime
    holder: str
    issuedAt: datetime
    mode: str
    remainingDays: int


class ModuleInfo(BaseModel):
    description: str | None = None
    id: str | None = None
    installDate: datetime | None = None
    installState: str | None = None
    title: str | None = None
    version: str | None = None
    versionMax: str | None = None
    versionMin: str | None = None


class StatusInfo(BaseModel):
    isAuditEnabled: bool
    isQuickShareEnabled: bool
    isReadOnly: bool
    isThumbnailGenerationEnabled: bool


class VersionInfo(BaseModel):
    display: str
    hotfix: str
    label: str
    major: str
    minor: str
    patch: str
    schema_: Annotated[int, Field(alias='schema')]


class RepositoryInfo(BaseModel):
    edition: str
    id: str
    license: LicenseInfo | None = None
    modules: list[ModuleInfo] | None = None
    status: StatusInfo
    version: VersionInfo


class RepositoryEntry(BaseModel):
    repository: RepositoryInfo


class DiscoveryEntry(BaseModel):
    entry: RepositoryEntry
