# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint, conlist, constr

from typing import Optional

from vrt_lss_studio.models.basic_process import BasicProcess
from vrt_lss_studio.models.experiment import Experiment
from vrt_lss_studio.models.experiment_settings import ExperimentSettings
from vrt_lss_studio.models.experiment_specification import ExperimentSpecification
from vrt_lss_studio.models.universal_data import UniversalData

from vrt_lss_studio.api_client import ApiClient
from vrt_lss_studio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExperimentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_experiment(self, experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment create request.")], **kwargs) -> str:  # noqa: E501
        """Create experiment  # noqa: E501

        Create new experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment(experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_specification: Experiment create request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.create_experiment_with_http_info(experiment_specification, **kwargs)  # noqa: E501

    @validate_arguments
    def create_experiment_with_http_info(self, experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment create request.")], **kwargs):  # noqa: E501
        """Create experiment  # noqa: E501

        Create new experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment_with_http_info(experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_specification: Experiment create request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_specification'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_experiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['experiment_specification']:
            _body_params = _params['experiment_specification']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "str",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_experiment_share(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> Experiment:  # noqa: E501
        """Share experiment  # noqa: E501

        Share experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment_share(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.create_experiment_share_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_experiment_share_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Share experiment  # noqa: E501

        Share experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment_share_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_experiment_share" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/share', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_experiment(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Experiment removal  # noqa: E501

        Experiment removal by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_experiment_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_experiment_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Experiment removal  # noqa: E501

        Experiment removal by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_experiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_experiment_share(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> Experiment:  # noqa: E501
        """Stop sharing  # noqa: E501

        Stop experiment sharing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment_share(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_experiment_share_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_experiment_share_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Stop sharing  # noqa: E501

        Stop experiment sharing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment_share_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_experiment_share" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/share', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def duplicate_experiment(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment duplicate request.")], **kwargs) -> str:  # noqa: E501
        """Experiment duplicate  # noqa: E501

        Experiment duplicate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_experiment(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_specification: Experiment duplicate request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.duplicate_experiment_with_http_info(experiment_key, experiment_specification, **kwargs)  # noqa: E501

    @validate_arguments
    def duplicate_experiment_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment duplicate request.")], **kwargs):  # noqa: E501
        """Experiment duplicate  # noqa: E501

        Experiment duplicate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_experiment_with_http_info(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_specification: Experiment duplicate request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'experiment_specification'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate_experiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['experiment_specification']:
            _body_params = _params['experiment_specification']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "str",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/duplication', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_json(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> UniversalData:  # noqa: E501
        """Export (JSON)  # noqa: E501

        Export data from the experiment to a VRt.Universal JSON file.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_json(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UniversalData
        """
        kwargs['_return_http_data_only'] = True
        return self.export_json_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def export_json_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Export (JSON)  # noqa: E501

        Export data from the experiment to a VRt.Universal JSON file.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_json_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UniversalData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "UniversalData",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/export/json', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_xlsx(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], timezone : Annotated[Optional[conint(strict=True, le=12, ge=-12)], Field(description="Timezone.")] = None, **kwargs) -> bytearray:  # noqa: E501
        """Export (XLSX)  # noqa: E501

        Export (XLSX).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_xlsx(experiment_key, timezone, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param timezone: Timezone.
        :type timezone: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        return self.export_xlsx_with_http_info(experiment_key, timezone, **kwargs)  # noqa: E501

    @validate_arguments
    def export_xlsx_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], timezone : Annotated[Optional[conint(strict=True, le=12, ge=-12)], Field(description="Timezone.")] = None, **kwargs):  # noqa: E501
        """Export (XLSX)  # noqa: E501

        Export (XLSX).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_xlsx_with_http_info(experiment_key, timezone, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param timezone: Timezone.
        :type timezone: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'timezone'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_xlsx" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('timezone') is not None:  # noqa: E501
            _query_params.append(('timezone', _params['timezone']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/export/xlsx', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def import_json(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], universal_data : Annotated[UniversalData, Field(..., description="Data (JSON).")], **kwargs) -> Experiment:  # noqa: E501
        """Import (JSON)  # noqa: E501

        Importing new data from a VRt.Universal JSON file. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json(experiment_key, universal_data, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param universal_data: Data (JSON). (required)
        :type universal_data: UniversalData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.import_json_with_http_info(experiment_key, universal_data, **kwargs)  # noqa: E501

    @validate_arguments
    def import_json_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], universal_data : Annotated[UniversalData, Field(..., description="Data (JSON).")], **kwargs):  # noqa: E501
        """Import (JSON)  # noqa: E501

        Importing new data from a VRt.Universal JSON file. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json_with_http_info(experiment_key, universal_data, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param universal_data: Data (JSON). (required)
        :type universal_data: UniversalData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'universal_data'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['universal_data']:
            _body_params = _params['universal_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/import/json', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def import_json_url(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], url : Annotated[constr(strict=True, max_length=512, min_length=10), Field(..., description="Url to json file.")], **kwargs) -> Experiment:  # noqa: E501
        """Import (JSON) from URL  # noqa: E501

        Importing new data from a VRt.Universal JSON file by url. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json_url(experiment_key, url, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param url: Url to json file. (required)
        :type url: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.import_json_url_with_http_info(experiment_key, url, **kwargs)  # noqa: E501

    @validate_arguments
    def import_json_url_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], url : Annotated[constr(strict=True, max_length=512, min_length=10), Field(..., description="Url to json file.")], **kwargs):  # noqa: E501
        """Import (JSON) from URL  # noqa: E501

        Importing new data from a VRt.Universal JSON file by url. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json_url_with_http_info(experiment_key, url, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param url: Url to json file. (required)
        :type url: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'url'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_json_url" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('url') is not None:  # noqa: E501
            _query_params.append(('url', _params['url']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/import/json_url', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def import_xlsx(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], body : Annotated[StrictStr, Field(..., description="Data (XLSX).")], timezone : Annotated[Optional[conint(strict=True, le=12, ge=-12)], Field(description="Timezone.")] = None, **kwargs) -> Experiment:  # noqa: E501
        """Import (XLSX)  # noqa: E501

        Import (XLSX).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_xlsx(experiment_key, body, timezone, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param body: Data (XLSX). (required)
        :type body: bytearray
        :param timezone: Timezone.
        :type timezone: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.import_xlsx_with_http_info(experiment_key, body, timezone, **kwargs)  # noqa: E501

    @validate_arguments
    def import_xlsx_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], body : Annotated[StrictStr, Field(..., description="Data (XLSX).")], timezone : Annotated[Optional[conint(strict=True, le=12, ge=-12)], Field(description="Timezone.")] = None, **kwargs):  # noqa: E501
        """Import (XLSX)  # noqa: E501

        Import (XLSX).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_xlsx_with_http_info(experiment_key, body, timezone, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param body: Data (XLSX). (required)
        :type body: bytearray
        :param timezone: Timezone.
        :type timezone: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'body',
            'timezone'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_xlsx" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('timezone') is not None:  # noqa: E501
            _query_params.append(('timezone', _params['timezone']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body']:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/import/xlsx', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_experiment(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> Experiment:  # noqa: E501
        """Reading experiment  # noqa: E501

        Getting experiment information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_experiment(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.read_experiment_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def read_experiment_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Reading experiment  # noqa: E501

        Getting experiment information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_experiment_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_experiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_experiment_calculation(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], process_name : Annotated[BasicProcess, Field(..., description="Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация ")], **kwargs) -> Experiment:  # noqa: E501
        """Run calculation  # noqa: E501

        Experiment calculation run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_calculation(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param process_name: Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация  (required)
        :type process_name: BasicProcess
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.run_experiment_calculation_with_http_info(experiment_key, process_name, **kwargs)  # noqa: E501

    @validate_arguments
    def run_experiment_calculation_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], process_name : Annotated[BasicProcess, Field(..., description="Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация ")], **kwargs):  # noqa: E501
        """Run calculation  # noqa: E501

        Experiment calculation run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_calculation_with_http_info(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param process_name: Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация  (required)
        :type process_name: BasicProcess
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'process_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_experiment_calculation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['process_name']:
            _path_params['process_name'] = _params['process_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/calculation/{process_name}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_experiment_validation(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], process_name : Annotated[BasicProcess, Field(..., description="Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация ")], **kwargs) -> Experiment:  # noqa: E501
        """Run validation  # noqa: E501

        Experiment validation run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_validation(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param process_name: Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация  (required)
        :type process_name: BasicProcess
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.run_experiment_validation_with_http_info(experiment_key, process_name, **kwargs)  # noqa: E501

    @validate_arguments
    def run_experiment_validation_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], process_name : Annotated[BasicProcess, Field(..., description="Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация ")], **kwargs):  # noqa: E501
        """Run validation  # noqa: E501

        Experiment validation run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_validation_with_http_info(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param process_name: Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация  (required)
        :type process_name: BasicProcess
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'process_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_experiment_validation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['process_name']:
            _path_params['process_name'] = _params['process_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/validation/{process_name}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def stop_experiment_calculation(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Calculation stop  # noqa: E501

        Calculation stop.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_experiment_calculation(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.stop_experiment_calculation_with_http_info(experiment_key, **kwargs)  # noqa: E501

    @validate_arguments
    def stop_experiment_calculation_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Calculation stop  # noqa: E501

        Calculation stop.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_experiment_calculation_with_http_info(experiment_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_experiment_calculation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/calculation', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_experiment(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment specification update request.")], **kwargs) -> Experiment:  # noqa: E501
        """Experiment update  # noqa: E501

        Rename \\ move experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_specification: Experiment specification update request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.update_experiment_with_http_info(experiment_key, experiment_specification, **kwargs)  # noqa: E501

    @validate_arguments
    def update_experiment_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_specification : Annotated[ExperimentSpecification, Field(..., description="Experiment specification update request.")], **kwargs):  # noqa: E501
        """Experiment update  # noqa: E501

        Rename \\ move experiment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_with_http_info(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_specification: Experiment specification update request. (required)
        :type experiment_specification: ExperimentSpecification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'experiment_specification'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_experiment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['experiment_specification']:
            _body_params = _params['experiment_specification']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_experiment_indicators(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], request_body : Annotated[conlist(constr(strict=True, max_length=256, min_length=2), max_items=100, min_items=0), Field(..., description="Indicators update request.")], **kwargs) -> Experiment:  # noqa: E501
        """Indicators update  # noqa: E501

        Updating the experiment indicators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_indicators(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Indicators update request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.update_experiment_indicators_with_http_info(experiment_key, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_experiment_indicators_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], request_body : Annotated[conlist(constr(strict=True, max_length=256, min_length=2), max_items=100, min_items=0), Field(..., description="Indicators update request.")], **kwargs):  # noqa: E501
        """Indicators update  # noqa: E501

        Updating the experiment indicators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_indicators_with_http_info(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Indicators update request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_experiment_indicators" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body']:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/indicators', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_experiment_settings(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_settings : Annotated[ExperimentSettings, Field(..., description="Experiment settings update request.")], **kwargs) -> Experiment:  # noqa: E501
        """Settings update  # noqa: E501

        Settings update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_settings(experiment_key, experiment_settings, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_settings: Experiment settings update request. (required)
        :type experiment_settings: ExperimentSettings
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Experiment
        """
        kwargs['_return_http_data_only'] = True
        return self.update_experiment_settings_with_http_info(experiment_key, experiment_settings, **kwargs)  # noqa: E501

    @validate_arguments
    def update_experiment_settings_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], experiment_settings : Annotated[ExperimentSettings, Field(..., description="Experiment settings update request.")], **kwargs):  # noqa: E501
        """Settings update  # noqa: E501

        Settings update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_settings_with_http_info(experiment_key, experiment_settings, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param experiment_settings: Experiment settings update request. (required)
        :type experiment_settings: ExperimentSettings
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Experiment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'experiment_settings'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_experiment_settings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['experiment_settings']:
            _body_params = _params['experiment_settings']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "Experiment",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/settings', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
