# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, confloat, constr

class CompatibilityPenalty(BaseModel):
    """
    Penalty for violation of compatibility. When taking into account the violation of compatibility with the location, the penalty is applied for each stop at the location. 
    """
    tag: constr(strict=True, max_length=256, min_length=1) = Field(..., description="Tag from list of [compatibilities](#section/Description/Compatibilities). ")
    penalty: confloat(le=1000000, ge=0, strict=True) = Field(..., description="Penalty for violation of compatibility for the specified tag. ")
    __properties = ["tag", "penalty"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompatibilityPenalty:
        """Create an instance of CompatibilityPenalty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompatibilityPenalty:
        """Create an instance of CompatibilityPenalty from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompatibilityPenalty.parse_obj(obj)

        _obj = CompatibilityPenalty.parse_obj({
            "tag": obj.get("tag"),
            "penalty": obj.get("penalty")
        })
        return _obj

