# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, constr, validator
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.possible_event import PossibleEvent

class Demand(BaseModel):
    """
    Request for a single action with a cargo (pickup / drop) or work at a location.
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Demand key, unique identifier.")
    demand_type: StrictStr = Field(..., description="The demand types are loading (`PICKUP`), unloading (`DROP`), work at the location (`WORK`).")
    target_cargos: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Cargo keys list for `PICKUP`, one cargo key for  `DROP`, empty key for `WORK`.")
    precedence_in_trip: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Precedence within a trip, 0 - the precedence is not taken into account.")
    precedence_in_order: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Precedence within an order, 0 - the precedence is not taken into account.")
    possible_events: conlist(PossibleEvent, max_items=25, min_items=1, unique_items=True) = Field(..., description="List of possible time windows and location keys to fulfil an order.")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "demand_type", "target_cargos", "precedence_in_trip", "precedence_in_order", "possible_events", "attributes"]

    @validator('demand_type')
    def demand_type_validate_enum(cls, v):
        if v not in ('PICKUP', 'DROP', 'WORK'):
            raise ValueError("must be one of enum values ('PICKUP', 'DROP', 'WORK')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Demand:
        """Create an instance of Demand from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in possible_events (list)
        _items = []
        if self.possible_events:
            for _item in self.possible_events:
                if _item:
                    _items.append(_item.to_dict())
            _dict['possible_events'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Demand:
        """Create an instance of Demand from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Demand.parse_obj(obj)

        _obj = Demand.parse_obj({
            "key": obj.get("key"),
            "demand_type": obj.get("demand_type"),
            "target_cargos": obj.get("target_cargos"),
            "precedence_in_trip": obj.get("precedence_in_trip") if obj.get("precedence_in_trip") is not None else 0,
            "precedence_in_order": obj.get("precedence_in_order") if obj.get("precedence_in_order") is not None else 0,
            "possible_events": [PossibleEvent.from_dict(_item) for _item in obj.get("possible_events")] if obj.get("possible_events") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

