# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictStr, constr, validator

class DemandFact(BaseModel):
    """
    Fact with demand.
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Fact key.")
    order_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Order key.")
    demand_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Demand key.")
    type: StrictStr = Field(..., description="Possible fact types:   * `START` - performer started to fulfill the demand   * `DONE` - performer finished to fulfill the demand   * `CANCEL` - demand calcelled    ")
    time: datetime = Field(..., description="Fact time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    __properties = ["key", "order_key", "demand_key", "type", "time"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('START', 'DONE', 'CANCEL'):
            raise ValueError("must be one of enum values ('START', 'DONE', 'CANCEL')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DemandFact:
        """Create an instance of DemandFact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DemandFact:
        """Create an instance of DemandFact from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DemandFact.parse_obj(obj)

        _obj = DemandFact.parse_obj({
            "key": obj.get("key"),
            "order_key": obj.get("order_key"),
            "demand_key": obj.get("demand_key"),
            "type": obj.get("type"),
            "time": obj.get("time")
        })
        return _obj

