# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr, validator
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.geopoint import Geopoint
from vrt_lss_studio.models.location_compatibilities import LocationCompatibilities
from vrt_lss_studio.models.time_window import TimeWindow

class Location(BaseModel):
    """
    Location - unique geographical location of the object with accessibility parameters. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Location key, unique identifier.")
    geopoint: Geopoint = ...
    arrival_duration: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    departure_duration: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    work_windows: Optional[conlist(TimeWindow, max_items=100, min_items=0, unique_items=True)] = Field(None, description="List of time windows for the location. If the list is empty or not specified, the location works without time limits. ")
    compatibilities: Optional[LocationCompatibilities] = None
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "geopoint", "arrival_duration", "departure_duration", "work_windows", "compatibilities", "attributes"]

    @validator('arrival_duration')
    def arrival_duration_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    @validator('departure_duration')
    def departure_duration_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Location:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in work_windows (list)
        _items = []
        if self.work_windows:
            for _item in self.work_windows:
                if _item:
                    _items.append(_item.to_dict())
            _dict['work_windows'] = _items
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Location:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Location.parse_obj(obj)

        _obj = Location.parse_obj({
            "key": obj.get("key"),
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "arrival_duration": obj.get("arrival_duration") if obj.get("arrival_duration") is not None else 'PT0S',
            "departure_duration": obj.get("departure_duration") if obj.get("departure_duration") is not None else 'PT0S',
            "work_windows": [TimeWindow.from_dict(_item) for _item in obj.get("work_windows")] if obj.get("work_windows") is not None else None,
            "compatibilities": LocationCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

