# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from vrt_lss_studio.models.statistics import Statistics
from vrt_lss_studio.models.trip_statistics import TripStatistics

class PlanStatistics(BaseModel):
    """
    General statistics on planned trips. 
    """
    total_statistics: Statistics = ...
    trips_statistics: conlist(TripStatistics, max_items=15001, min_items=0, unique_items=True) = Field(..., description="List of statistics per trip, where. ")
    __properties = ["total_statistics", "trips_statistics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlanStatistics:
        """Create an instance of PlanStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of total_statistics
        if self.total_statistics:
            _dict['total_statistics'] = self.total_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in trips_statistics (list)
        _items = []
        if self.trips_statistics:
            for _item in self.trips_statistics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trips_statistics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlanStatistics:
        """Create an instance of PlanStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PlanStatistics.parse_obj(obj)

        _obj = PlanStatistics.parse_obj({
            "total_statistics": Statistics.from_dict(obj.get("total_statistics")) if obj.get("total_statistics") is not None else None,
            "trips_statistics": [TripStatistics.from_dict(_item) for _item in obj.get("trips_statistics")] if obj.get("trips_statistics") is not None else None
        })
        return _obj

