# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, confloat, conint, conlist, constr, validator
from vrt_lss_studio.models.basic_state import BasicState
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow
from vrt_lss_studio.models.cargo_rotation_type import CargoRotationType

class TableOrderFields(BaseModel):
    """
    Order\\demand fields for table.
    """
    essence_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field('ORDER', description="Essence type.")
    enabled: Optional[StrictBool] = Field(True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    state: Optional[BasicState] = None
    type: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Order\\demand type.")
    hard_time_window: Optional[BasicTimeWindow] = None
    soft_time_window: Optional[BasicTimeWindow] = None
    reward: Optional[confloat(ge=0, strict=True)] = Field(0, description="The total reward for orders fulfillment.")
    mass: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Weight in kilograms.")
    volume: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Volume in cubic meters.")
    capacity_a: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Additional capacity parameter (A) for measuring cargoes and compartments in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a compartment). ")
    capacity_b: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Additional capacity parameter (B) for measuring cargoes and compartments in alternative units. ")
    capacity_c: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Additional capacity parameter (C) for measuring cargoes and compartments in alternative units. ")
    order_features: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=15001, min_items=0, unique_items=True)] = Field(None, description="Order features list.")
    order_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=15001, min_items=0, unique_items=True)] = Field(None, description="List of requirements for an order being delivered during the same trip.")
    performer_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Requirements list for the performer. Used for checking the compatibility of the performer and the order (work). ")
    performer_blacklist: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="A list of requirements that the performer is not allowed to have. Used for checking the compatibility of the performer and the order (work). This list should not intersect with `performer_restrictions`. ")
    width: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Width in meters, used to check the transport box capacity.")
    height: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Height in meters, used to check the transport box capacity.")
    length: Optional[confloat(le=1000000, ge=0, strict=True)] = Field(0, description="Length in meters, used to check the transport box capacity.")
    rotation: Optional[conlist(CargoRotationType, max_items=4, min_items=0, unique_items=True)] = Field(None, description="List of possibilities of a object rotations (90 degree step):   * `ALL` - can rotate by any axis   * `YAW` - can yaw   * `PITCH` - can pitch   * `ROLL` - can roll  Empty list means object rotations is prohibited.  More about [cargo placement](#section/Description/Cargo-placement).")
    box_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="List of necessary restrictions for a transport's box. ")
    cargo_features: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Cargo's features list. Used to check whether the cargo is compatible with other cargos. ")
    cargo_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Requirements list for the cargo. Used to check whether the cargo is compatible with other cargos. ")
    demands_count: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Demands count.")
    trip_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    attributes: Optional[constr(strict=True, max_length=1000000, min_length=0)] = Field('', description="Attributes.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "state", "type", "hard_time_window", "soft_time_window", "reward", "mass", "volume", "capacity_a", "capacity_b", "capacity_c", "order_features", "order_restrictions", "performer_restrictions", "performer_blacklist", "width", "height", "length", "rotation", "box_restrictions", "cargo_features", "cargo_restrictions", "demands_count", "trip_key", "attributes"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ('ORDER', 'DEMAND'):
            raise ValueError("must be one of enum values ('ORDER', 'DEMAND')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableOrderFields:
        """Create an instance of TableOrderFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hard_time_window
        if self.hard_time_window:
            _dict['hard_time_window'] = self.hard_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soft_time_window
        if self.soft_time_window:
            _dict['soft_time_window'] = self.soft_time_window.to_dict()
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if hard_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.hard_time_window is None and "hard_time_window" in self.__fields_set__:
            _dict['hard_time_window'] = None

        # set to None if soft_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.soft_time_window is None and "soft_time_window" in self.__fields_set__:
            _dict['soft_time_window'] = None

        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableOrderFields:
        """Create an instance of TableOrderFields from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableOrderFields.parse_obj(obj)

        _obj = TableOrderFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'ORDER',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "state": obj.get("state"),
            "type": obj.get("type"),
            "hard_time_window": BasicTimeWindow.from_dict(obj.get("hard_time_window")) if obj.get("hard_time_window") is not None else None,
            "soft_time_window": BasicTimeWindow.from_dict(obj.get("soft_time_window")) if obj.get("soft_time_window") is not None else None,
            "reward": obj.get("reward") if obj.get("reward") is not None else 0,
            "mass": obj.get("mass") if obj.get("mass") is not None else 0,
            "volume": obj.get("volume") if obj.get("volume") is not None else 0,
            "capacity_a": obj.get("capacity_a") if obj.get("capacity_a") is not None else 0,
            "capacity_b": obj.get("capacity_b") if obj.get("capacity_b") is not None else 0,
            "capacity_c": obj.get("capacity_c") if obj.get("capacity_c") is not None else 0,
            "order_features": obj.get("order_features"),
            "order_restrictions": obj.get("order_restrictions"),
            "performer_restrictions": obj.get("performer_restrictions"),
            "performer_blacklist": obj.get("performer_blacklist"),
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "rotation": obj.get("rotation"),
            "box_restrictions": obj.get("box_restrictions"),
            "cargo_features": obj.get("cargo_features"),
            "cargo_restrictions": obj.get("cargo_restrictions"),
            "demands_count": obj.get("demands_count") if obj.get("demands_count") is not None else 0,
            "trip_key": obj.get("trip_key"),
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else ''
        })
        return _obj

