# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictStr, constr, validator
from vrt_lss_studio.models.service_name import ServiceName

class Tracedata(BaseModel):
    """
    Data for request tracing.
    """
    code: StrictStr = Field(..., description="Unique process identifier. If an asynchronous process is running, then the code for it will be the same, although other fields may differ. ")
    client: constr(strict=True, max_length=256, min_length=2) = Field(..., description="The unique identifier of the client (`company_key` + `_|_` + `username`) that made the request. ")
    server: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Server identifier.")
    service: ServiceName = ...
    operation: constr(strict=True, max_length=256, min_length=3) = Field(..., description="Operation identifier.")
    time: datetime = Field(..., description="Date and time service method run in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    __properties = ["code", "client", "server", "service", "operation", "time"]

    @validator('client')
    def client_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    @validator('server')
    def server_validate_regular_expression(cls, v):
        if not re.match(r"\w+", v):
            raise ValueError(r"must validate the regular expression /\w+/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Tracedata:
        """Create an instance of Tracedata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Tracedata:
        """Create an instance of Tracedata from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Tracedata.parse_obj(obj)

        _obj = Tracedata.parse_obj({
            "code": obj.get("code"),
            "client": obj.get("client"),
            "server": obj.get("server"),
            "service": obj.get("service"),
            "operation": obj.get("operation"),
            "time": obj.get("time")
        })
        return _obj

