# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, constr
from vrt_lss_studio.models.track_point import TrackPoint

class TransportFact(BaseModel):
    """
    Fact.
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Fact key.")
    time: datetime = Field(..., description="Fact time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    transport_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Transport's key.")
    position: TrackPoint = ...
    __properties = ["key", "time", "transport_key", "position"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportFact:
        """Create an instance of TransportFact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportFact:
        """Create an instance of TransportFact from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportFact.parse_obj(obj)

        _obj = TransportFact.parse_obj({
            "key": obj.get("key"),
            "time": obj.get("time"),
            "transport_key": obj.get("transport_key"),
            "position": TrackPoint.from_dict(obj.get("position")) if obj.get("position") is not None else None
        })
        return _obj

