# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.5.1990

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, conlist
from vrt_lss_studio.models.capacity_factor import CapacityFactor
from vrt_lss_studio.models.transport_factor import TransportFactor

class TripAssumptions(BaseModel):
    """
    Planning assumptions - ability to disable a part of the planning business logic. 
    """
    transport_factor: Optional[conlist(TransportFactor, max_items=10, min_items=0, unique_items=True)] = Field(None, description="Transport speed change coefficients.")
    capacity_factor: Optional[conlist(CapacityFactor, max_items=10, min_items=0, unique_items=True)] = Field(None, description="Transport capacity change coefficients. Change the `capacity` parameters for all boxes and `max_capacity` for the transport. ")
    disable_compatibility: Optional[StrictBool] = Field(False, description="Disable the accounting for capacity. If `true` is specified, all becomes compatible with everything. ")
    disable_capacity: Optional[StrictBool] = Field(False, description="Disable the accounting for capacity. If `true` is specified, all transports can accommodate an unlimited cargo amount. ")
    same_order_time_window: Optional[StrictBool] = Field(False, description="Use for calculation the same (specified) time window for orders and demands. The time window is specified from the beginning of the earliest window to the end of the latest window from all orders and demands. ")
    expand_shift_time_window: Optional[StrictBool] = Field(False, description="Expand the time window for performer and transport shifts.  The left border of the first shift extends to the left border of the specified window, right border extends to the right border or to the beginning of the next window for this entity. Each next shift moves the right border to the next shift or to the right border of the specified window. ")
    __properties = ["transport_factor", "capacity_factor", "disable_compatibility", "disable_capacity", "same_order_time_window", "expand_shift_time_window"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripAssumptions:
        """Create an instance of TripAssumptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in transport_factor (list)
        _items = []
        if self.transport_factor:
            for _item in self.transport_factor:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transport_factor'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in capacity_factor (list)
        _items = []
        if self.capacity_factor:
            for _item in self.capacity_factor:
                if _item:
                    _items.append(_item.to_dict())
            _dict['capacity_factor'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripAssumptions:
        """Create an instance of TripAssumptions from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TripAssumptions.parse_obj(obj)

        _obj = TripAssumptions.parse_obj({
            "transport_factor": [TransportFactor.from_dict(_item) for _item in obj.get("transport_factor")] if obj.get("transport_factor") is not None else None,
            "capacity_factor": [CapacityFactor.from_dict(_item) for _item in obj.get("capacity_factor")] if obj.get("capacity_factor") is not None else None,
            "disable_compatibility": obj.get("disable_compatibility") if obj.get("disable_compatibility") is not None else False,
            "disable_capacity": obj.get("disable_capacity") if obj.get("disable_capacity") is not None else False,
            "same_order_time_window": obj.get("same_order_time_window") if obj.get("same_order_time_window") is not None else False,
            "expand_shift_time_window": obj.get("expand_shift_time_window") if obj.get("expand_shift_time_window") is not None else False
        })
        return _obj

