'''tests for GeoCoords

.. This software is released under an MIT/X11 open source license.
   Copyright 2012-2015 Diffeo, Inc.
'''

from dossier.fc import FeatureCollection
from dossier.fc.geocoords import GeoCoords, GeoCoordsSerializer



def test_geo_fcdefault():
    fc = FeatureCollection()
    assert isinstance(fc['!co_LOC'], GeoCoords)

def test_geo_default():
    fo = GeoCoords()
    assert fo['foo'] == []


def test_geo_roundtrip():
    fc = FeatureCollection()
    fc['!co_LOC']['foo'].append((-55, 22, 0))
    fc2 = FeatureCollection.loads(fc.dumps())
    assert fc['!co_LOC'] == fc2['!co_LOC']

def test_geocoords():
    data = {'Boston': [(-72, 44, 2), (99, -22., 1)]}

    geo = GeoCoords(data)

    out = GeoCoordsSerializer.dumps(geo)
    
    geo2 = GeoCoordsSerializer.loads(out)

    assert geo is not geo2
    assert geo == geo2
