import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#api_management_name ApiManagementApiSchema#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#api_name ApiManagementApiSchema#api_name}
    */
    readonly apiName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#content_type ApiManagementApiSchema#content_type}
    */
    readonly contentType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#resource_group_name ApiManagementApiSchema#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#schema_id ApiManagementApiSchema#schema_id}
    */
    readonly schemaId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#value ApiManagementApiSchema#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#timeouts ApiManagementApiSchema#timeouts}
    */
    readonly timeouts?: ApiManagementApiSchemaTimeouts;
}
export interface ApiManagementApiSchemaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#create ApiManagementApiSchema#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#delete ApiManagementApiSchema#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#read ApiManagementApiSchema#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema#update ApiManagementApiSchema#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiSchemaTimeoutsToTerraform(struct?: ApiManagementApiSchemaTimeoutsOutputReference | ApiManagementApiSchemaTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiSchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiSchemaTimeouts | undefined;
    set internalValue(value: ApiManagementApiSchemaTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema azurerm_api_management_api_schema}
*/
export declare class ApiManagementApiSchema extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_schema azurerm_api_management_api_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiSchemaConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiSchemaConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    get apiName(): string;
    set apiName(value: string);
    get apiNameInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    get contentTypeInput(): string | undefined;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    get schemaIdInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiSchemaTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiSchemaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiSchemaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
