import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBatchAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#encryption DataAzurermBatchAccount#encryption}
    */
    readonly encryption?: DataAzurermBatchAccountEncryption[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#name DataAzurermBatchAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#resource_group_name DataAzurermBatchAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#timeouts DataAzurermBatchAccount#timeouts}
    */
    readonly timeouts?: DataAzurermBatchAccountTimeouts;
}
export interface DataAzurermBatchAccountEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#key_vault_key_id DataAzurermBatchAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
}
export declare function dataAzurermBatchAccountEncryptionToTerraform(struct?: DataAzurermBatchAccountEncryption | cdktf.IResolvable): any;
export interface DataAzurermBatchAccountKeyVaultReference {
}
export declare function dataAzurermBatchAccountKeyVaultReferenceToTerraform(struct?: DataAzurermBatchAccountKeyVaultReference): any;
export declare class DataAzurermBatchAccountKeyVaultReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchAccountKeyVaultReference | undefined;
    set internalValue(value: DataAzurermBatchAccountKeyVaultReference | undefined);
    get id(): string;
    get url(): string;
}
export declare class DataAzurermBatchAccountKeyVaultReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchAccountKeyVaultReferenceOutputReference;
}
export interface DataAzurermBatchAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account#read DataAzurermBatchAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBatchAccountTimeoutsToTerraform(struct?: DataAzurermBatchAccountTimeoutsOutputReference | DataAzurermBatchAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBatchAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBatchAccountTimeouts | undefined;
    set internalValue(value: DataAzurermBatchAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account azurerm_batch_account}
*/
export declare class DataAzurermBatchAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_batch_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/batch_account azurerm_batch_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBatchAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBatchAccountConfig);
    get accountEndpoint(): string;
    private _encryption?;
    get encryption(): DataAzurermBatchAccountEncryption[] | cdktf.IResolvable;
    set encryption(value: DataAzurermBatchAccountEncryption[] | cdktf.IResolvable);
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | DataAzurermBatchAccountEncryption[] | undefined;
    get id(): string;
    private _keyVaultReference;
    get keyVaultReference(): DataAzurermBatchAccountKeyVaultReferenceList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get poolAllocationMode(): string;
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get storageAccountId(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermBatchAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBatchAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBatchAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
