import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventhubNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace#name DataAzurermEventhubNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace#resource_group_name DataAzurermEventhubNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace#timeouts DataAzurermEventhubNamespace#timeouts}
    */
    readonly timeouts?: DataAzurermEventhubNamespaceTimeouts;
}
export interface DataAzurermEventhubNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace#read DataAzurermEventhubNamespace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventhubNamespaceTimeoutsToTerraform(struct?: DataAzurermEventhubNamespaceTimeoutsOutputReference | DataAzurermEventhubNamespaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventhubNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermEventhubNamespaceTimeouts | undefined;
    set internalValue(value: DataAzurermEventhubNamespaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace azurerm_eventhub_namespace}
*/
export declare class DataAzurermEventhubNamespace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_eventhub_namespace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace azurerm_eventhub_namespace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventhubNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubNamespaceConfig);
    get autoInflateEnabled(): cdktf.IResolvable;
    get capacity(): number;
    get dedicatedClusterId(): string;
    get defaultPrimaryConnectionString(): string;
    get defaultPrimaryConnectionStringAlias(): string;
    get defaultPrimaryKey(): string;
    get defaultSecondaryConnectionString(): string;
    get defaultSecondaryConnectionStringAlias(): string;
    get defaultSecondaryKey(): string;
    get id(): string;
    get kafkaEnabled(): cdktf.IResolvable;
    get location(): string;
    get maximumThroughputUnits(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermEventhubNamespaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventhubNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermEventhubNamespaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
