import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#name DataAzurermKeyVaultAccessPolicyA#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#timeouts DataAzurermKeyVaultAccessPolicyA#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultAccessPolicyTimeouts;
}
export interface DataAzurermKeyVaultAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#read DataAzurermKeyVaultAccessPolicyA#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultAccessPolicyTimeoutsToTerraform(struct?: DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference | DataAzurermKeyVaultAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultAccessPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultAccessPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy azurerm_key_vault_access_policy}
*/
export declare class DataAzurermKeyVaultAccessPolicyA extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_access_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy azurerm_key_vault_access_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultAccessPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultAccessPolicyAConfig);
    get certificatePermissions(): string[];
    get id(): string;
    get keyPermissions(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get secretPermissions(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
